<?php

namespace App\DBRealTestSupport;

use App\Modules\Shared\Application\Util;
use Faker\Factory;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class BookingRelationshipMother {
    
    public static function build1($lock, $id = 1) {
        $faker = Factory::create();
        return [
            'Id_BookingRelationship' => $id,
            'BookingRelationship_Name' => Str::title($faker->text(rand(5, 250))),
            'BookingRelationship_Abrv' => Str::upper(Util::generateString(4)),
            'BookingRelationship_Lock' => $lock,
            'BookingRelationship_Status' => $faker->randomElement([1, 2])
        ];
    }

    public static function push1($lock, $id = 1) {
        return self::push(self::build1($lock, $id));
    }

    private static function push($object) {
        $response = DB::select("CALL `sp_booking_relationship_insert` (?,?,?,?)", [
            $object['BookingRelationship_Name'],
            $object['BookingRelationship_Abrv'],
            $object['BookingRelationship_Lock'],
            $object['BookingRelationship_Status']
        ]);
        $object['Id_BookingRelationship'] = $response[0]->Response_Id;
        return $object;
    }

}