<?php

namespace App\DBRealTestSupport\BookingTour;

use App\DBRealTestSupport\PackageFeeMother;
use App\DBRealTestSupport\PackageMother;
use App\DBRealTestSupport\PackageRateMother;
use App\DBRealTestSupport\PackageTourMother;
use App\DBRealTestSupport\PackageTranslMother;
use App\DBRealTestSupport\TourMother;
use App\DBRealTestSupport\TourTranslMother;

trait PackageWithoutFullGenerator
{
    static $language;
    static $categoryTour;
    static $typeTour;
    static $country;
    static $state;
    static $city;
    static $typeRate;


    private function generatePackageWithoutFull($idBookingTour, $BookingTour_DateStart)
    {
        $package = PackageMother::push1();
        PackageTranslMother::push1($package['Id_Package'], static::$language['Id_Language']);
        $tour = TourMother::push1(static::$categoryTour['Id_CategoryTour'], static::$typeTour['Id_TypeTour'], static::$country['Id_Country'], static::$state['Id_State'], static::$city['Id_City']);
        TourTranslMother::push1($tour['Id_Tour'], static::$language['Id_Language']);
        
        $packageTour = PackageTourMother::push1($package['Id_Package'], $tour['Id_Tour']);
        
        PackageFeeMother::pushUnFull1($package['Id_Package'], $tour['Id_Tour']);
        $packageRate = PackageRateMother::push1($package['Id_Package'], static::$typeRate['Id_TypeRate']);
        $this->changeBookingTour($packageTour['Id_PackageTour'], $idBookingTour, $BookingTour_DateStart, $packageRate['PackageRate_Type']);
    }
}
