<?php

namespace App\DBRealTestSupport;

use App\Modules\Shared\Application\Util;
use Faker\Factory;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class HtlCampMother {
    
    public static function build1($id = 1) {
        $faker = Factory::create();
        return [
            'Id_HtlCamp'			=> $id,
            'HtlCamp_Name'		    => Str::title($faker->text(rand(5, 250))),
            'HtlCamp_Abrv'		    => Str::upper(Util::generateString(10)),
            'HtlCamp_Availability'  => rand(5, 100),
            'HtlCamp_Status'		=> $faker->randomElement([1, 2])
        ];
    }

    public static function push1($id = 1) {
        return self::push(self::build1($id));
    }

    private static function push($object) {
        DB::select("CALL `sp_htl_camp_insert` (?,?,?,@sts,@cod,@msg,@id)", [
            $object['HtlCamp_Name'],
            $object['HtlCamp_Abrv'],
            $object['HtlCamp_Status'],
        ]);
        $response = DB::select('SELECT @sts,@cod,@msg,@id');
        if ($response[0]->{'@sts'} == 200) {
            $object['Id_HtlCamp'] = $response[0]->{'@id'};
        }
        return $object;
    }

}