<?php

namespace App\DBRealTestSupport;

use App\Modules\Shared\Application\Util;
use Faker\Factory;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class HtlRoomMother {
    
    public static function build1($idCamp, $id = 1) {
        $faker = Factory::create();
        return [
            'Id_HtlRoom'			=> $id,
            'HtlRoom_Number'		=> Str::title($faker->text(rand(5, 250))),
            'HtlRoom_Status'		=> $faker->randomElement([1, 2]),
            'Id_HtlCamp'            => $idCamp
        ];
    }

    public static function push1($idCamp, $id = 1) {
        return self::push(self::build1($idCamp, $id));
    }

    private static function push($object) {
        DB::select("CALL `sp_htl_room_insert` (?,?,?,@sts,@cod,@msg,@id)", [
            $object['HtlRoom_Number'],
            $object['HtlRoom_Status'],
            $object['Id_HtlCamp'],
        ]);
        $response = DB::select('SELECT @sts,@cod,@msg,@id');
        if ($response[0]->{'@sts'} == 200) {
            $object['Id_HtlRoom'] = $response[0]->{'@id'};
        }
        return $object;
    }

}