<?php

namespace App\DBRealTestSupport;

use App\Modules\Shared\Application\Util;
use Faker\Factory;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class LanguageMother
{
    
    public static function build1($id = 1)
    {
        return [
            'Id_Language' => $id,
            'Language_Code' => 'EN',
            'Language_Name' => 'English',
            'Language_Content' => 2,
            'Language_Status' => 2
        ];
    }

    public static function buildBasicLanguage($id = 1)
    {
        $faker = Factory::create();
        return [
            'Id_Language'       => $id,
            'Language_Code'     => Str::upper(Util::generateString(2)),
            'Language_Name'     => Str::title($faker->text(rand(5, 250))),
            'Language_Content'  => $faker->randomElement([1, 2]),
            'Language_Status'     => $faker->randomElement([1, 2]),
        ];
    }

    public static function push1($id = 1)
    {
        return self::push(self::build1($id));
    }

    public static function pushBasic($id = 1)
    {
        return self::push(self::buildBasicLanguage($id));
    }

    public static function pushBasicDefault($id = 1)
    {
        return self::pushDefault(self::buildBasicLanguage($id));
    }

    private static function push($object)
    {
        $response = DB::select("CALL `sp_language_insert` (?,?,?,?)", [
            $object['Language_Code'],
            $object['Language_Name'],
            $object['Language_Content'],
            $object['Language_Status']
        ])[0];
        $object['Id_Language'] = $response->Response_Id;
        return $object;
    }

    private static function pushDefault($object)
    {
        DB::insert(
            "INSERT INTO `t_language` (`Id_Language`,`Language_Code`,`Language_Name`,`Language_Content`, `Language_Status`) VALUE (?,?,?,?,?)",
            [
                $object['Id_Language'],
                $object['Language_Code'],
                $object['Language_Name'],
                $object['Language_Content'],
                $object['Language_Status']
            ]
        );
        return $object;
    }
}
