<?php

namespace App\DBRealTestSupport;

use Faker\Factory;
use Illuminate\Support\Facades\DB;
use App\DBRealTestSupport\TableCreation as TC;

class LeadPassengerMother
{
    
    public static function build1(
        $idLeadBooking,
        $idTypeDocument = null,
        $IdUserCountry = null,
        $IdTypeRate = null,
        $id = 1
    ) {
        
        $idTypeDocument = $idTypeDocument ?? TypeDocumentMother::push1()['Id_TypeDocument'];
        $IdUserCountry = $IdUserCountry ?? UserCountryMother::push1()['Id_UserCountry'];
        $IdTypeRate = $IdTypeRate ?? TypeRateMother::push1()['Id_TypeRate'];
        $faker = Factory::create();
        return [
            'Id_LeadPassenger' => $id,
            'LeadPassenger_Date' => date('Y-m-d H:i:s'),
            'LeadPassenger_Name' => $faker->text(rand(5, 100)),
            'LeadPassenger_LastName' => $faker->text(rand(5, 100)),
            'LeadPassenger_Email' => $faker->text(rand(5, 250)),
            'LeadPassenger_Phone' => $faker->text(rand(5, 50)),
            'LeadPassenger_Gender' => $faker->randomElement([1, 2]),
            'LeadPassenger_DOB' => date('Y-m-d'),
            'LeadPassenger_NoDocument' => $faker->text(rand(5, 20)),
            'LeadPassenger_Restriction' => $faker->text(rand(5, 1000)),
            'LeadPassenger_Extras' => $faker->text(rand(5, 1000)),
            'LeadPassenger_ImgDocument1' => $faker->text(rand(5, 250)),
            'LeadPassenger_Status' => $faker->randomElement([1, 2]),
            'LeadPassenger_InfoStatus' => $faker->randomElement([1, 2]),

            'Id_LeadBooking' => $idLeadBooking,
            'Id_TypeDocument' => $idTypeDocument,
            'Id_UserCountry' => $IdUserCountry,
            'Id_TypeRate' => $IdTypeRate
        ];
    }

    public static function push1($idAdmin, $idGuideLanguage = null, $idLanguage = null, $idLead = null, $id = 1)
    {
        return self::push(self::build1($idAdmin, $idGuideLanguage, $idLanguage, $idLead, $id = 1));
    }

    private static function push($object)
    {
        $response = DB::select("CALL `sp_lead_passenger_insert`(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,@sts,@cod,@msg,@id)", [
            $object['LeadPassenger_Name'],
            $object['LeadPassenger_LastName'],
            $object['LeadPassenger_Email'],
            $object['LeadPassenger_Phone'],
            $object['LeadPassenger_Gender'],
            $object['LeadPassenger_DOB'],
            $object['LeadPassenger_NoDocument'],
            $object['LeadPassenger_Restriction'],
            $object['LeadPassenger_Extras'],
            $object['LeadPassenger_ImgDocument1'],
            $object['LeadPassenger_Status'],
            $object['LeadPassenger_InfoStatus'],
            $object['Id_LeadBooking'],
            $object['Id_TypeDocument'],
            $object['Id_UserCountry'],
            $object['Id_TypeRate'],
        ]);
        $response = DB::select('SELECT @sts,@cod,@msg,@id');
        if ($response[0]->{'@sts'} == 200) {
            $object['Id_LeadPassenger'] = $response[0]->{'@id'};
        }
        return $object;
    }

    public static function tablesToClear()
    {
        return array_merge(
            [TC::LEAD_PASSENGER],
            LeadBookingMother::tablesToClear(),
            TypeDocumentMother::tablesToClear(),
            [TC::user_country],
            [TC::type_rate, TC::type_rate_transl]
        );
    }
}
