<?php

namespace App\DBRealTestSupport;

use Faker\Factory;
use Illuminate\Support\Facades\DB;
use App\DBRealTestSupport\TableCreation as TC;

class ProviderMother
{
    public static function build1($idTypeDocument, $idTypeProvider, $idCountry, $idState, $idCity, $id = 1)
    {
        $faker = Factory::create();
        return [
            'Id_Provider' => $id,
            'Provider_BusinessName' => $faker->text(rand(5, 250)),
            'Provider_TradeName' => $faker->text(rand(5, 250)),
            'Provider_NoDocument' => $faker->text(rand(5, 50)),
            'Provider_Address' => $faker->text(rand(5, 250)),
            'Provider_Phone' => $faker->text(rand(5, 30)),
            'Provider_Status' => $faker->randomElement([1, 2]),
            'Id_TypeDocument' => $idTypeDocument,
            'Id_TypeProvider' => $idTypeProvider,
            'Id_Country' => $idCountry,
            'Id_State' => $idState,
            'Id_City' => $idCity
        ];
    }

    public static function push1($idTypeDocument, $idTypeProvider, $idCountry, $idState, $idCity, $id = 1)
    {
        return self::push(self::build1($idTypeDocument, $idTypeProvider, $idCountry, $idState, $idCity, $id));
    }

    private static function push($object)
    {
        $response = DB::select("CALL `sp_provider_insert` (?,?,?,?,?,?,?,?,?,?,?)", [
            $object['Provider_BusinessName'],
            $object['Provider_TradeName'],
            $object['Provider_NoDocument'],
            $object['Provider_Address'],
            $object['Provider_Phone'],
            $object['Provider_Status'],
            $object['Id_TypeDocument'],
            $object['Id_TypeProvider'],
            $object['Id_Country'],
            $object['Id_State'],
            $object['Id_City'],
        ]);
        $object['Id_Provider'] = $response[0]->Response_Id;
        return $object;
    }

    public static function tablesToClear()
    {
        return [
            TC::PROVIDER,
            TC::type_provider,
            TC::country,
            TC::state,
            TC::city
        ];
    }
}
