<?php

namespace App\DBRealTestSupport;

use Faker\Factory;
use App\DBRealTestSupport\TableCreation as TC;

class RedistributionMother {

    public static function build1($invoices, $id = 1) {
        $faker = Factory::create();
        return [
            'Id_Redistribution'         => $id,
            'Redistribution_Amount'     => array_reduce($invoices, fn($p, $c) => $p + $c['Amount'], 0),
            'Redistribution_Currency'   => 'USD',
            'Redistribution_Remark'     => '-',
            'Redistribution_Status'     => $faker->randomElement([1, 2]),
            'Invoices'                  => json_encode($invoices)
        ];
    }

    public static function push1($invoices, $idTypePayment, $tester, $token, $id = 1) {
        return self::push(self::build1($invoices, $idTypePayment, $id), $tester, $token);
    }

    private static function push($object, $tester, $token)
    {
        $tester->post(
            '/owner/redistribution',
            $object,
            [
                'Token' => $token,
                'Url' => $token
            ]
        );
        return $object;
    }

    public static function clear()
    {
        return [TC::redistribution, TC::redistribution_detail, ...BookingMother::clear(),];
    }
}
