<?php

namespace App\DBRealTestSupport;

use App\Modules\Shared\Application\Util;
use Faker\Factory;
use Illuminate\Support\Facades\DB;
use App\DBRealTestSupport\TableCreation as TC;

class TypeDocumentMother
{
    
    public static function build1($id = 1)
    {
        $faker = Factory::create();
        return [
            'Id_TypeDocument' => $id,
            'TypeDocument_Name' => $faker->text(rand(5, 250)),
            'TypeDocument_Abrv' => Util::generateString(4),
            'TypeDocument_ForPassenger' => $faker->randomElement([1, 2]),
            'TypeDocument_Status' => 2
        ];
    }

    public static function push1($id = 1)
    {
        return self::push(self::build1($id));
    }

    private static function push($object)
    {
        $response = DB::select("CALL `sp_type_document_insert`(?,?,?,?)", [
            $object['TypeDocument_Name'],
            $object['TypeDocument_Abrv'],
            $object['TypeDocument_ForPassenger'],
            $object['TypeDocument_Status']
        ])[0];
        $object['Id_TypeDocument'] = $response->Response_Id;
        return $object;
    }

    public static function tablesToClear()
    {
        return [ TC::type_document, TC::type_document_transl ];
    }
}
