<?php

namespace App\DBRealTestSupport;

use App\Modules\Shared\Application\Util;
use Faker\Factory;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class UserMother
{
    
    public static function build1($idTypeDocument = null, $idUserCountry = null, $id = 1)
    {
        $idTypeDocument = $idTypeDocument ?? TypeDocumentMother::push1()['Id_TypeDocument'];
        $idUserCountry = $idUserCountry ?? UserCountryMother::push1()['Id_UserCountry'];
        $faker = Factory::create();
        return [
            'Id_User'                   => $id,
            'User_DateCreate'           => date('Y-m-d H:i:s'),
            'User_Name'                 => Str::title($faker->text(rand(5, 100))),
            'User_LastName'             => Str::title($faker->text(rand(5, 100))),
            'User_Email'                => $faker->email,
            'User_Password'             => sha1('mother'),
            'User_PhoneCode'            => '122',
            'User_Phone'                => substr($faker->phoneNumber, 0, 20),
            'User_NoDocument'           => Str::upper(Util::generateInt(rand(5, 19))),
            'User_Address'              => Str::title($faker->text(rand(5, 250))),
            'User_ContactName'          => Str::title($faker->text(rand(5, 100))),
            'User_ContactPhone'         => substr($faker->phoneNumber, 0, 20),
            'User_Type'                 => $faker->randomElement([1, 2]), // web 1, endosador 2
            'User_Status'               => 2,
            'Id_TypeDocument'           => $idTypeDocument,
            'Id_UserCountry'            => $idUserCountry,
        ];
    }
    public static function push1($idTypeDocument = null, $idUserCountry = null, $id = 1)
    {
        return self::push(self::build1($idTypeDocument, $idUserCountry, $id));
    }

    private static function push($object)
    {
        $response = DB::select("CALL `sp_user_insert` (?,?,?,?,?,?,?,?,?,?,?,?,?)", [
            $object['User_Name'],
            $object['User_LastName'],
            $object['User_Email'],
            $object['User_PhoneCode'],
            $object['User_Phone'],
            $object['User_NoDocument'],
            $object['User_Address'],
            $object['User_ContactName'],
            $object['User_ContactPhone'],
            $object['User_Type'],
            $object['User_Status'],
            $object['Id_TypeDocument'],
            $object['Id_UserCountry'],
        ]);
        $object['Id_User'] = $response[0]->Response_Id;
        return $object;
    }
}
