<?php

namespace App\DBTestSupport;

use Illuminate\Support\Facades\DB;

class TypeDocumentMother {
    
    public static function build1($id = 1) {
        return [
            'Id_TypeDocument' => $id,
            'TypeDocument_Name' => 'DNI',
            'TypeDocument_Abrv' => 'DNI',
            'TypeDocument_Status' => 2
        ];
    }
    
    public static function build2($id = 1) {
        return [
            'Id_TypeDocument' => $id,
            'TypeDocument_Name' => 'Pasaporte',
            'TypeDocument_Abrv' => 'PASS',
            'TypeDocument_ForPassenger' => 1,
            'TypeDocument_Status' => 2
        ];
    }

    public static function push1($id = 1) {
        return self::push(self::build1($id));
    }

    public static function push2($id = 1) {
        return self::push(self::build2($id));
    }

    private static function push($object) {
        DB::select("CALL `sp_type_document_insert` (?,?,?,?)", [
            $object['TypeDocument_Name'],
            $object['TypeDocument_Abrv'],
            $object['TypeDocument_Status']
        ]);
        return $object;
    }

}