<?php
namespace App\Http\Controllers\Client;

use App\Http\Controllers\Controller;

use DB;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

use App\Http\Helpers\ResponseBuilder;
use App\Http\Helpers\ParamsValidator;
use Intervention\Image\ImageManagerStatic as Image;

class c_Package_Fee extends Controller
{
	private $oDomain;

	public function __construct()
	{
		$this->oDomain = "Package Fee";
	}

	public function List(Request $Request, $Id){
		$oResponse  = array();

		$oResponse = ParamsValidator::Validate_Id($Id,$this->oDomain);

		if ($oResponse["Response_Code"] == 200) {
			$oParam = array( $Id );
			$oData  = DB::select('call sp_client_package_fee_list(?)',$oParam);

			$oResponse["Response_Status"]			= 200;
			$oResponse["Response_Code"]				= 200;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $this->oDomain." list";
			$oResponse["Response_Data"]				= $oData;
			$oResponse["Response_Error_Message"]	= "";
			$oResponse["Response_Error_Reason"]		= "";
		}

		return ResponseBuilder::Response($oResponse);
	}

	
}