<?php
namespace App\Http\Controllers\Client;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Http\Helpers\ResponseBuilder;
use App\Http\Helpers\ParamsValidator;
use App\Providers\BookingMailSender;
use Illuminate\Support\Facades\DB;

class c_Schedule extends Controller
{
    private $oDomain;

    public function __construct()
    {
        $this->oDomain = "Schedule";
    }

    public function Pay (Request $Request){
        $oResponse  = array();
        $oValParams = [
            'Id_Schedule'           => 'required|int',
            'CashMovement'          => 'required|string'
        ];


        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Request ($Request, $oValParams, $this->oDomain);
        
        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {   
            
            #region Deserializar

            $oCashMovement  = json_decode ($Request->input('CashMovement'));

            #endregion

            #region Cash Movement

            $oParam = [
                date('Y-m-d'),
                $oCashMovement->CashMovement_Amount,
                $oCashMovement->CashMovement_Currency,
                $oCashMovement->CashMovement_Name,
                $oCashMovement->CashMovement_LastName,
                $oCashMovement->CashMovement_Email,
                $oCashMovement->CashMovement_Country,
                $oCashMovement->CashMovement_City,
                $oCashMovement->CashMovement_Address,
                $oCashMovement->CashMovement_Phone,
                $oCashMovement->CashMovement_ReceiptNumber,
                $oCashMovement->CashMovement_CardLast,
                $oCashMovement->CashMovement_CardNumber,
                $oCashMovement->CashMovement_CardBrand,
                $oCashMovement->CashMovement_CardType,
                $oCashMovement->CashMovement_CardIssuer,
                '',
                14
            ];

            $oDataCashMovement = DB::select('call sp_cash_movement_insert(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,0)', $oParam);
            $oData = $oDataCashMovement;
            #endregion

            
            if ($oData[0]->Response_Success == 1) {
                #region Schedule Detail
                // $oScheduleDetail = DB::select ('call sp_schedule_detail_list(?)', [ $Request->input ('Id_Schedule') ]);
                $invoiceDetail = json_decode($oCashMovement->Invoices);
                
                foreach ($invoiceDetail as $detail) {
                    $oDataInvoice = DB::select ('call sp_cash_movement_detail_insert(?,?,?,?,?)', [
                        $detail->Amount,
                        $oDataCashMovement[0]->Id_CashMovement,
                        $detail->Id_Invoice,
                        1,
                        1
                    ]);
                    $oData = $oDataInvoice;
                    if ($oData[0]->Response_Success != 1) {
                        break;
                    }
                }
                #endregion

                #region Schedule
                if ($oData[0]->Response_Success == 1) {
                    $dataPayment = DB::select('call sp_schedule_pay(?)', [ $Request->input("Id_Schedule") ]);
                    
                    if ($dataPayment[0]->Response_Success == 1) {
                        try {
                            $oSchedule = DB::select('call sp_schedule_index(?)', [ $Request->input("Id_Schedule") ]);
                            BookingMailSender::sendBookingByMail(
                                $oSchedule[0]->Id_Booking,
                                $this->oDomain,
                                BookingMailSender::ONLY_PAYMENT
                            );
                        } catch (\Throwable $ex) {
                        }
                    }
                }

                #endregion
            }

            #region Get data
            
            $oResponse["Response_Status"]           = $oData[0]->Response_Status;
            $oResponse["Response_Code"]             = $oData[0]->Response_Code;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $oData[0]->Response_Message;
            $oResponse["Response_Data"]             = null;
            $oResponse["Response_Error_Message"]    = $oData[0]->Response_Message;
            $oResponse["Response_Error_Reason"]     = $oData[0]->Response_Reason;
            
            #endregion
        }

        return ResponseBuilder::Response($oResponse);

    }

    public function Search (Request $Request){

        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Request (
            $Request, 
            [ 'Schedule_Token'    => 'string' ],
            $this->oDomain
        );
        $Schedule_Token = $Request->input('Schedule_Token', '');
        
        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {       
            $oParam = [ $Schedule_Token ];
            $oData  = DB::select('call sp_schedule_search (?)',$oParam);
            
            $oResponse["Response_Status"]           = 200;
            $oResponse["Response_Code"]             = 200;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $this->oDomain." Index";
            $oResponse["Response_Data"]             = $oData;
            $oResponse["Response_Error_Message"]    = "";
            $oResponse["Response_Error_Reason"]     = "";
        }

        return ResponseBuilder::Response($oResponse);
    }
        
}