<?php
namespace App\Http\Controllers\Mail;

use App\Http\Controllers\Controller;

use DB;
use Illuminate\Http\Request;
use Illuminate\Support\Str;


class c_Mail_Structure extends Controller {

    private $Style_Base			= "display: block; height: auto; width: 100%; box-sizing: border-box; margin: 0px; padding: 5px 0px;";
	
	private $Style_Base_2		= "height: auto; border-box; margin: 0px; padding: 5px 0px;";
    private $Font_Family 		= "Segoe, 'Segoe UI', 'DejaVu Sans', 'Trebuchet MS', Verdana, 'sans-serif'";
    
    private $Color_Primary		= "#f56a2a";
	private $Color_Secondary	= "#f56a2a";

	private $Color_White		= "#FCFCFC";
	private $Color_White_Light	= "#FFFFFF";
	private $Color_White_Dark	= "#F3F3F3";

	private $Color_Black		= "#777777";
	private $Color_Black_Light	= "#999999";
	private $Color_Black_Dark	= "#222222";

	private $Color_Blue 		= "#007aff";
    private $Color_Green 		= "#34c759";
    private $Color_Indigo 		= "#5856d6";
    private $Color_Orange 		= "#ff9500";
    private $Color_Pink 		= "#ff2d55";
    private $Color_Purple 		= "#af52de";
    private $Color_Red 			= "#ff3b30";
    private $Color_Teal 		= "#5ac8fa";
    private $Color_Yellow 		= "#ffcc00";

	private $Padding			= "5px 20px";
    private $Margin				= "10px 0";

    
    public function Get_Subtitle ($Text, $Align, $reduce = 1) {
		switch ($Align) {
			case "RIGHT": 	$Content_Align = "text-align: right"; 	break;
			case "LEFT": 	$Content_Align = "text-align: left"; 	break;
			case "CENTER": 	$Content_Align = "text-align: center"; 	break;
			case "JUSTIFY": $Content_Align = "text-align: justify"; break;
			default: 		$Content_Align = "text-align: left"; 	break;
		}

		$Content = "
		<p style=\"line-height: 1.5; font-family: $this->Font_Family; font-size: " . ($reduce * 13) . 
			"px; color: $this->Color_Black_Dark; $Content_Align\">
			$Text
		</p>
		";

		return $Content;
	}
}