<?php
namespace App\Http\Controllers\Owner\External;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;
use Illuminate\Support\Str;

use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use App\Modules\External\Application\ExternalInserter;
use App\Modules\External\Domain\External;
use App\Modules\External\Domain\ExternalAbrv;
use App\Modules\External\Domain\ExternalAsset;
use App\Modules\External\Domain\ExternalLock;
use App\Modules\External\Domain\ExternalName;
use App\Modules\External\Domain\ExternalStatus;
use App\Modules\External\Infraestructure\MysqlExternalRepository;
use App\Modules\External\Infraestructure\ExternalValidators;

class ExternalInsertController extends Controller
{
    private $domain;
    /** @var HistoryData */
    private $history;

    public function __construct()
    {
        $this->domain = "External";
        $this->history = new HistoryData(HistoryTables::EXTERNAL);
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator())->validate($request->all(), $this->domain, ExternalValidators::INSERT);
        $response = (new ExternalInserter(new MysqlExternalRepository()))
            ->__invoke(new External(
                new ExternalName($request->input('External_Name')),
                new ExternalAbrv($request->input('External_Abrv')),
                new ExternalAsset($request->input('External_Asset')),
                new ExternalLock(ExternalLock::ANSWER_NO),
                new ExternalStatus($request->input('External_Status'))
            ));
        $this->history->insertBasic($request, $response['Response_Data']['Id']);

        return ResponseBuilder::Response($response);
    }
}
