<?php
namespace App\Http\Controllers\Owner\ExternalReview;

use App\Http\Controllers\Controller;

use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\ExternalReview\Application\ExternalReviewIndexer;
use App\Modules\ExternalReview\Domain\IdExternalReview;
use App\Modules\ExternalReview\Infraestructure\MysqlExternalReviewRepository;

class ExternalReviewIndexController extends Controller
{
    public function __construct()
    {
    }

    public function __invoke($Id)
    {
        $response = (new ExternalReviewIndexer(new MysqlExternalReviewRepository()))
            ->__invoke(new IdExternalReview($Id));

        return ResponseBuilder::Response($response);
    }
}
