<?php
namespace App\Http\Controllers\Owner\ExternalReviewProvider;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\ExternalReview\Domain\IdExternalReview;
use App\Modules\ExternalReviewProvider\Application\ExternalReviewProviderIndexer;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use App\Modules\ExternalReviewProvider\Application\ExternalReviewProviderInserter;
use App\Modules\ExternalReviewProvider\Domain\ExternalReviewProvider;
use App\Modules\ExternalReviewProvider\Domain\ExternalReviewProviderStatus;
use App\Modules\ExternalReviewProvider\Domain\ExternalReviewProviderType;
use App\Modules\ExternalReviewProvider\Infraestructure\MysqlExternalReviewProviderRepository;
use App\Modules\ExternalReviewProvider\Infraestructure\ExternalReviewProviderValidators;
use App\Modules\GroupProvider\Domain\IdGroupProvider;

class ExternalReviewProviderInsertController extends Controller
{
    private $domain;
    /** @var HistoryData */
    private $history;
    
    private ExternalReviewProviderInserter $inserter;

    public function __construct()
    {
        $this->domain = "ExternalReviewProvider";
        $this->history = new HistoryData(HistoryTables::EXTERNAL_REVIEW);
        $this->inserter = new ExternalReviewProviderInserter(new MysqlExternalReviewProviderRepository());
        $this->indexer = new ExternalReviewProviderIndexer(new MysqlExternalReviewProviderRepository());
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator())->validate($request->all(), $this->domain, ExternalReviewProviderValidators::INSERT);

        $response = $this->inserter->__invoke(
            new ExternalReviewProvider(
                new ExternalReviewProviderType($request->input('ExternalReviewProvider_Type')),
                new ExternalReviewProviderStatus($request->input('ExternalReviewProvider_Status')),
                new IdExternalReview($request->input('Id_ExternalReview')),
                new IdGroupProvider($request->input('Id_GroupProvider')),
            )
        );
        $this->history->insertBasic($request, true);

        return ResponseBuilder::Response($response);
    }
}
