<?php

namespace App\Http\Controllers\Owner\GroupProvider;

use App\Http\Controllers\Controller;
use App\Http\Helpers\ParamsValidator;
use Illuminate\Http\Request;

use App\Http\Helpers\ResponseBuilder;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use Illuminate\Support\Facades\DB;

final class Update extends Controller
{
    private $oDomain;
    /** @var HistoryData */
    private $history;

    public function __construct()
    {
        $this->oDomain = "Group Provider";
        $this->history = new HistoryData(HistoryTables::group_provider);
    }

    public function __invoke(Request $Request)
    {
        $oResponse  = array();
        $oValParams = [
            'Id_GroupProvider'      => 'required|int',
            'GroupProvider_Type'    => 'required|int',
            'Id_Group'              => 'required|int',
            'Id_Provider'           => 'required|int'
        ];
        
        (new LaravelValidator())->validate($Request->all(), $this->oDomain, $oValParams);

        $this->history->obtainOld($Request->input("Id_Group"));
        
        $oParam = [
            $Request->input("Id_GroupProvider"),
            $Request->input("GroupProvider_Type"),
            $Request->input("Id_Group"),
            $Request->input("Id_Provider")
        ];
        $oData = DB::select('call sp_group_provider_update(?,?,?,?)', $oParam);

        //  RESPONSE
        if ($oData[0]->Response_Success == 1) {
            $this->history->update(
                $Request->input("Id_Group"),
                $this->history->oldValue,
                [ $Request->all() ],
                $Request
            );
        }
        
        $oResponse = [];
        $oResponse["Response_Status"]           = $oData[0]->Response_Status;
        $oResponse["Response_Code"]             = $oData[0]->Response_Code;
        $oResponse["Response_Domain"]           = $this->oDomain;
        $oResponse["Response_Message"]          = $oData[0]->Response_Message;
        $oResponse["Response_Data"]             = null;
        $oResponse["Response_Error_Message"]    = $oData[0]->Response_Message;
        $oResponse["Response_Error_Reason"]     = $oData[0]->Response_Reason;

        return ResponseBuilder::Response($oResponse);
    }
}
