<?php
namespace App\Http\Controllers\Owner\Lead;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Http\Helpers\ResponseBuilder;
use App\Modules\Lead\Application\List\LeadListerQuery;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class LeadListController extends Controller
{
    public function __construct(
        private QueryBus $queryBus
    ) {
    }

    public function __invoke($Action)
    {
        /** @var LeadListerResponse $response */
        $response = $this->queryBus->ask(new LeadListerQuery($Action));

        return ResponseBuilder::Response($response->response());
    }
}
