<?php
namespace App\Http\Controllers\Owner\ModuleNotification;

use App\Http\Controllers\Controller;

use App\Http\Helpers\ResponseBuilder;
use App\Modules\Admin\Domain\IdAdmin;
use App\Modules\ModuleNotification\Application\ModuleNotificationUpdater;
use App\Modules\ModuleNotification\Domain\IdModuleNotification;
use App\Modules\ModuleNotification\Domain\ModuleNotificationStatus;
use App\Modules\ModuleNotification\Domain\UpdateModuleNotification;
use App\Modules\ModuleNotification\Infraestructure\ModuleNotificationValidators;
use App\Modules\ModuleNotification\Infraestructure\MysqlModuleNotificationRepository;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

final class Update extends Controller
{
    private $oDomain;

    public function __construct()
    {
        $this->oDomain = 'ModuleNotification';
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator)->validate($request->all(), $this->oDomain, ModuleNotificationValidators::UPDATE);
        
        $data = DB::select('call sp_admin_session_get(?,?)', [
            $request->header('Token'),
            $request->ip()
        ])[0];
        $response = (new ModuleNotificationUpdater(new MysqlModuleNotificationRepository))
            ->__invoke(
                new UpdateModuleNotification(
                    new IdModuleNotification($request->input('Id_ModuleNotification')),
                    new ModuleNotificationStatus($request->input('ModuleNotification_Status')),
                    new IdAdmin($data->Response_Id_Admin)
                )
            );
        return ResponseBuilder::Response($response);
    }
}
