<?php
namespace App\Http\Controllers\Owner\PassengerReview;

use App\Http\Controllers\Controller;

use App\Http\Helpers\ResponseBuilder;
use App\Modules\Group\Domain\IdGroup;
use App\Modules\PassengerReview\Application\PassengerReviewSearchByGroup;
use App\Modules\PassengerReview\Infraestructure\MysqlPassengerReviewSearchByGroupRepository;

final class SearchByGroup extends Controller
{

    public function __construct()
    {
        $this->oDomain = 'PassengerReview';
    }

    public function __invoke(int $idGroup)
    {
        $response = (new PassengerReviewSearchByGroup(new MysqlPassengerReviewSearchByGroupRepository))
            ->__invoke(
                new IdGroup($idGroup),
                'answered',
                config('var.PATH_PUBLIC') . config('var.USER_COUNTRY_THUMB')
            );
        return ResponseBuilder::Response($response);
    }
}
