<?php
namespace App\Http\Controllers\Owner\ReviewNotification;

use App\Http\Controllers\Controller;

use App\Http\Helpers\ResponseBuilder;
use App\Modules\ReviewNotification\Application\Index\ReviewNotificationIndexerQuery;
use App\Modules\ReviewNotification\Application\Index\ReviewNotificationIndexerResponse;
use App\Modules\ReviewNotificationTour\Application\List\ReviewNotificationTourListerQuery;
use App\Modules\ReviewNotificationTour\Application\List\ReviewNotificationTourListerResponse;
use App\Modules\LeadPassenger\Application\List\LeadPassengerListerQuery;
use App\Modules\LeadPassenger\Application\List\LeadPassengerListerResponse;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

class ReviewNotificationIndexController extends Controller
{
    public function __construct(
        private QueryBus $queryBus
    ) {
    }

    public function __invoke($Id)
    {
        /** @var ReviewNotificationIndexerResponse $response */
        $response = $this->queryBus->ask(new ReviewNotificationIndexerQuery($Id));
        return ResponseBuilder::Response($response->response());
    }
}
