<?php
namespace App\Http\Controllers\Owner;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;
use Illuminate\Support\Str;

use App\Http\Helpers\ResponseBuilder;
use App\Http\Helpers\ParamsValidator;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use Illuminate\Support\Facades\DB;
use Intervention\Image\ImageManagerStatic as Image;

class c_Admin_Role_Auth extends Controller
{
	private $oDomain;
	/** @var HistoryData */
	private $history;

	public function __construct()
	{
		$this->oDomain = "Admin Role Auth";
		$this->history = new HistoryData (HistoryTables::admin_role_auth);
	}

	public function Insert(Request $Request){
		$oResponse  = array();
		$oValParams = array(    'AdminRoleAuth_Insert'	=> 'required|int',
								'AdminRoleAuth_Update'	=> 'required|int',
								'AdminRoleAuth_Delete'	=> 'required|int',
								'Id_AdminRole'			=> 'required|int',
								'Id_Directory'			=> 'required|int'
							);


		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Request($Request,$oValParams,$this->oDomain);
		
		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {			
			$oParam = array(    $Request->input("AdminRoleAuth_Insert"),
								$Request->input("AdminRoleAuth_Update"),
								$Request->input("AdminRoleAuth_Delete"),
								$Request->input("Id_AdminRole"),
								$Request->input("Id_Directory")
							);
			$oData = DB::select('call sp_admin_role_auth_insert(?,?,?,?,?)',$oParam);

			//  RESPONSE
			if ($oData[0]->Response_Success == 1) {
				#region HISTORY EXEC
				$this->history->insertBasic ($Request);
				#endregion
			} else { }
			
			$oResponse["Response_Status"]			= $oData[0]->Response_Status;
			$oResponse["Response_Code"]				= $oData[0]->Response_Code;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $oData[0]->Response_Message;
			$oResponse["Response_Data"]				= null;
			$oResponse["Response_Error_Message"]	= $oData[0]->Response_Message;
			$oResponse["Response_Error_Reason"]		= $oData[0]->Response_Reason;
		}

		return ResponseBuilder::Response($oResponse);
		
	}

	public function InsertAll(Request $Request){
		$oSucces	= true;
		$oResponse  = array();
		$oValParams = array(    'Id_AdminRole'	=> 'required|int',
								'Directory'		=> 'required|string'
							);
		
		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Request($Request,$oValParams,$this->oDomain);
				
		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {
			
			$oldValue = DB::select ('call sp_admin_role_auth_list(?)', [ $Request->input('Id_AdminRole')]);
			
			$Directory = json_decode($Request->input("Directory"));

			for ($k = 0; $k < count($Directory); $k++) {
				if($Directory[$k]->Id_AdminRoleAuth==0){
					
					$oParam = array(    $Directory[$k]->AdminRoleAuth_Insert,
										$Directory[$k]->AdminRoleAuth_Update,
										$Directory[$k]->AdminRoleAuth_Delete,
										$Request->input("Id_AdminRole"),
										$Directory[$k]->Id_Directory
							);
					$oData = DB::select('call sp_admin_role_auth_insert(?,?,?,?,?)',$oParam);
				}else{
					if($Directory[$k]->AdminRoleAuth_Status==0){
						
						$oParam = array( $Directory[$k]->Id_AdminRoleAuth);
						$oData 	= DB::select('call sp_admin_role_auth_delete(?)',$oParam);
					}else{
						$oParam = array(    $Directory[$k]->Id_AdminRoleAuth,
											$Directory[$k]->AdminRoleAuth_Insert,
											$Directory[$k]->AdminRoleAuth_Update,
											$Directory[$k]->AdminRoleAuth_Delete,
											$Request->input("Id_AdminRole"),
											$Directory[$k]->Id_Directory
										);
						$oData = DB::select('call sp_admin_role_auth_update(?,?,?,?,?,?)',$oParam);

					}
				}
				
				if($oData[0]->Response_Success == 0){
					$oSucces = false;
					break;
				}
			}

			if ($oSucces == true) {

				$newValue = DB::select ('call sp_admin_role_auth_list(?)', [ $Request->input('Id_AdminRole')]);
				$this->history->update (
					$Request->input("Id_AdminRole"),
					$oldValue,
					$newValue,
					$Request
				);
				
				$oData = array(
					array(
						"Response_Status" 	=> 200,
						"Response_Code" 	=> 200,
						"Response_Message" 	=> "Permisos actualizados con exito",
						"Response_Reason" 	=> null
					)
				);

				$oData = json_decode(json_encode($oData));
			}

			$oResponse["Response_Status"]			= $oData[0]->Response_Status;
			$oResponse["Response_Code"]				= $oData[0]->Response_Code;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $oData[0]->Response_Message;
			$oResponse["Response_Data"]				= null;
			$oResponse["Response_Error_Message"]	= $oData[0]->Response_Message;
			$oResponse["Response_Error_Reason"]		= $oData[0]->Response_Reason;
		}

		return ResponseBuilder::Response($oResponse);
	}

	public function Update(Request $Request) {
		$oResponse  = array();
		$oValParams = array(    'Id_AdminRoleAuth'		=> 'required|int',
								'AdminRoleAuth_Insert'	=> 'required|int',
								'AdminRoleAuth_Update'	=> 'required|int',
								'AdminRoleAuth_Delete'	=> 'required|int',
								'Id_AdminRole'			=> 'required|int',
								'Id_Directory'			=> 'required|int'
							);


		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Request($Request,$oValParams,$this->oDomain);
		
		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {			
			$oParam = array(    $Request->input("Id_AdminRole"),
								$Request->input("AdminRoleAuth_Insert"),
								$Request->input("AdminRoleAuth_Update"),
								$Request->input("AdminRoleAuth_Delete"),
								$Request->input("Id_AdminRole"),
								$Request->input("Id_Directory")
							);
			$oData = DB::select('call sp_admin_role_auth_update(?,?,?,?,?,?)',$oParam);

			//  RESPONSE
			if($oData[0]->Response_Success == 1){
				
			}else{
				
			}
			
			$oResponse["Response_Status"]			= $oData[0]->Response_Status;
			$oResponse["Response_Code"]				= $oData[0]->Response_Code;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $oData[0]->Response_Message;
			$oResponse["Response_Data"]				= null;
			$oResponse["Response_Error_Message"]	= $oData[0]->Response_Message;
			$oResponse["Response_Error_Reason"]		= $oData[0]->Response_Reason;
		}

		return ResponseBuilder::Response($oResponse);

	}

	public function Delete(Request $Request, $Id){
		$oResponse  = array();

		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Id($Id,$this->oDomain);
		
		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {			
			$oParam = array( $Id );
			$oData 	= DB::select('call sp_admin_role_auth_delete(?)',$oParam);

			//  RESPONSE
			if($oData[0]->Response_Success == 1){
				
			}else{
				
			}
			
			$oResponse["Response_Status"]			= $oData[0]->Response_Status;
			$oResponse["Response_Code"]				= $oData[0]->Response_Code;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $oData[0]->Response_Message;
			$oResponse["Response_Data"]				= null;
			$oResponse["Response_Error_Message"]	= $oData[0]->Response_Message;
			$oResponse["Response_Error_Reason"]		= $oData[0]->Response_Reason;
		}

		return ResponseBuilder::Response($oResponse);
	}

	public function Index(Request $Request, $Id){
		$oResponse  = array();

		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Id($Id,$this->oDomain);
		
		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {		
			$oParam = array( $Id );
			$oData 	= DB::select('call sp_admin_role_auth_index(?)', $oParam);
			
			$oResponse["Response_Status"]			= 200;
			$oResponse["Response_Code"]				= 200;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $this->oDomain." Index";
			$oResponse["Response_Data"]				= $oData;
			$oResponse["Response_Error_Message"]	= "";
			$oResponse["Response_Error_Reason"]		= "";
		}

		return ResponseBuilder::Response($oResponse);
	}
	public function MenuList(Request $Request){
		$oResponse  = array();

		$oParam = array( $Request->header("Token") );
		$oData  = DB::select('call sp_admin_role_auth_list_menu(?)',$oParam);

		$oResponse["Response_Status"]			= 200;
		$oResponse["Response_Code"]				= 200;
		$oResponse["Response_Domain"]			= $this->oDomain;
		$oResponse["Response_Message"]			= $this->oDomain." list ";
		$oResponse["Response_Data"]				= $oData;
		$oResponse["Response_Error_Message"]	= "";
		$oResponse["Response_Error_Reason"]		= "";

		return ResponseBuilder::Response($oResponse);
	}
	public function List(Request $Request, $Id_AdminRole){
		$oResponse  = array();

		$oResponse = ParamsValidator::Validate_Id($Id_AdminRole,$this->oDomain);

		if ($oResponse["Response_Code"] == 200) {
			$oParam = array( $Id_AdminRole );
			$oData= array();
			$oPermission  = DB::select('call sp_admin_role_auth_list(?)',$oParam);
			$oDirectory=DB::select('call sp_directory_list()');
			
			$Directory=['Directory'=>$oDirectory];
			$Permission=['Permission'=>$oPermission];
			array_push($oData,$Permission);
			array_push($oData,$Directory);
			//$oData->Directory	=DB::select('call sp_directory_list()');


			$oResponse["Response_Status"]			= 200;
			$oResponse["Response_Code"]				= 200;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $this->oDomain." list ".$Id_AdminRole;
			$oResponse["Response_Data"]				= $oData;
			$oResponse["Response_Error_Message"]	= "";
			$oResponse["Response_Error_Reason"]		= "";
		}

		return ResponseBuilder::Response($oResponse);
	}
}