<?php
namespace App\Http\Controllers\Owner;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Http\Helpers\ResponseBuilder;
use App\Http\Helpers\ParamsValidator;
use Illuminate\Support\Facades\DB;

class c_Admin_Session extends Controller
{
    private $oDomain;


    public function __construct()
    {
        $this->oDomain = "Admin Session";
    }

    public function Insert(Request $Request)
    {
        $oResponse  = array();
        $oValParams = array(    'Admin_Email'           => 'required|string|max:250',
                                'Admin_Password'        => 'required|string|max:250'
                            );


        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Request($Request, $oValParams, $this->oDomain);
        
        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
            $oParam = array(    $Request->input("Admin_Email"),
                                $Request->input("Admin_Password"),
                                $Request->ip()
                            );
            $oData = DB::select('call sp_admin_session_insert(?,?,?)', $oParam);

            //  RESPONSE
            if ($oData[0]->Response_Success == 1) {
                $Response_Data  = array("Token"     => $oData[0]->Response_Token );
            }else{
                $Response_Data  = null;
            }
            
            $oResponse["Response_Status"]           = $oData[0]->Response_Status;
            $oResponse["Response_Code"]             = $oData[0]->Response_Code;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $oData[0]->Response_Message;
            $oResponse["Response_Data"]             = $Response_Data;
            $oResponse["Response_Error_Message"]    = $oData[0]->Response_Message;
            $oResponse["Response_Error_Reason"]     = $oData[0]->Response_Reason;
        }

        return ResponseBuilder::Response($oResponse);
    }

    public static function Update(Request $Request)
    {
        if ($Request->header("Token") != "" || $Request->header("Url") == "") {
            $url=explode("/", $Request->header("Url"));
            $oParam     = array(    $Request->header("Token"),
                                    $Request->ip(),
                                    count($url)-1,
                                    $Request->header("Url"));
            $oData      = DB::select('call sp_admin_session_update(?,?,?,?)', $oParam);

            return $oData;
        }
    }

        
    public function Index(Request $Request)
    {
        
        $oResponse  = [];

        if ($Request->header("Token") != "") {
            $oData = DB::select('call sp_admin_session_get(?,?)', [
                $Request->header('Token'),
                ''
            ])[0];

            $oResponse["Response_Status"]           = $oData->Response_Status;
            $oResponse["Response_Code"]             = $oData->Response_Code;
            $oResponse["Response_Domain"]           = $oData->Response_Success;
            $oResponse["Response_Message"]          = $oData->Response_Message;
            $oResponse["Response_Data"]             = [
                [
                    'Id_Admin'                  => $oData->Response_Id_Admin,
                    'AdminRole_Admin'           => $oData->Response_AdminRole_Admin,
                    'AdminRole_CalendarAccess'  => $oData->Response_AdminRole_CalendarAccess,
                    'Id_AdminRole'              => $oData->Response_Id_AdminRole,
                    'AdminRole_Name'            => $oData->AdminRole_Name,
                    'Admin_Name'                => $oData->Admin_Name,
                    'Admin_LastName'            => $oData->Admin_LastName,
                    'Admin_Abrv'                => $oData->Admin_Abrv,
                    'Admin_Color'               => $oData->Admin_Color
                ]
            ];
            $oResponse["Response_Error_Message"]    = $oData->Response_Message;
            $oResponse["Response_Error_Reason"]     = $oData->Response_Reason;
        } else {
            $oResponse["Response_Status"]           = 401;
            $oResponse["Response_Code"]             = 401;
            $oResponse["Response_Domain"]           = "Global";
            $oResponse["Response_Message"]          = "Missing request header 'authorization' for method parameter of type String";
            $oResponse["Response_Data"]             = null;
            $oResponse["Response_Error_Message"]    = "Bad Request";
            $oResponse["Response_Error_Reason"]     = "Missing request header 'authorization' for method parameter of type String";
        }

        return ResponseBuilder::Response($oResponse);
    }

    public function Delete(Request $Request)
    {
        $oResponse  = array();
        
        //  INGRESANDO DATOS
        if ($Request->header("Token") != "") {
            $oParam     = array( $Request->header("Token") );
            $oData      = DB::select('call sp_admin_session_delete(?)', $oParam);

            //  RESPONSE
            if ($oData[0]->Response_Success == 1) {
            } else {
            }
            
            $oResponse["Response_Status"]           = $oData[0]->Response_Status;
            $oResponse["Response_Code"]             = $oData[0]->Response_Code;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $oData[0]->Response_Message;
            $oResponse["Response_Data"]             = null;
            $oResponse["Response_Error_Message"]    = $oData[0]->Response_Message;
            $oResponse["Response_Error_Reason"]     = $oData[0]->Response_Reason;
        }

        return ResponseBuilder::Response($oResponse);
    }
}
