<?php
namespace App\Http\Controllers\Owner;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;
use Illuminate\Support\Str;

use App\Http\Helpers\ResponseBuilder;
use App\Http\Helpers\ParamsValidator;
use App\Providers\BookingMailSender;
use App\Http\Controllers\Owner\c_Invoice;
use App\Http\Controllers\Owner\c_Invoice_Detail;
use App\Http\Controllers\Owner\CashMovementDetail;
use App\Http\Controllers\Owner\c_Invoice_Fee;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Mail\c_Mail_User;
use App\Modules\Booking\Application\BookingPackSearch;
use App\Modules\Booking\BookingDeleter;
use App\Modules\Booking\Infraestructure\BookingValidators;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Mail;
use Throwable;

class c_Booking extends Controller
{
    private $oDomain;
    /** @var HistoryData */
    private $history;
    /** @var HistoryData */
    private $historyBookingTour;

    public function __construct()
    {
        $this->oDomain = "Booking";
        $this->history = new HistoryData(HistoryTables::booking);
        $this->historyBookingTour = new HistoryData(HistoryTables::booking_tour);
    }

    public static function getHistoryData($Id_Booking)
    {
        $invoiceListJSON = json_encode(BookingMailSender::GetInvoiceList($Id_Booking));
        return self::getReportData($Id_Booking, $invoiceListJSON);
    }
        
    public function Insert(Request $Request)
    {
        $Id_User            = 0;
        $Id_Booking         = 0;
        $Id_BookingTour     = 0;
        $Id_BookingUpgrade  = 0;
        $Id_BookingExtra    = 0;
        $oData              = null;


        $oResponse  = array();
        $oValParams = [
            'Id_User'               => 'int',
            'User_Name'             => 'required|string|max:100',
            'User_LastName'         => 'required|string|max:100',
            'User_Email'            => 'required|string|max:250',
            'User_Phone'            => 'string|max:20',
            'Id_UserCountry'        => 'required|int',
            'Booking'               => 'required|string'
        ];

        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Request($Request, $oValParams, $this->oDomain);

        if ($oResponse["Response_Code"] == 200) {
            #region USER
            if ($Request->input("Id_User") == 0) {
                $oParam     = array(    $Request->input("User_Name"),
                                        $Request->input("User_LastName"),
                                        $Request->input("User_Email"),
                                        $Request->input("User_Phone"),
                                        $Request->input("Id_UserCountry")
                                    );
                $oData_User = DB::select('call sp_client_user_insert(?,?,?,?,?)', $oParam);

                if($oData_User[0]->Response_Success == 1){
                    
                    $Id_User                = $oData_User[0]->Response_Id;

                    $Variables              = array(    "Lang"          => 1,
                                                        "User"          => $Request->input("User_Email"),
                                                        "Password"      => $oData_User[0]->Response_Password,
                                                        'ResourcesUrl'  => BookingMailSender::getResourcesUrl()[0]->Credential_Value,
                                                        'WebUrl'        => BookingMailSender::getWebUrl()[0]->Credential_Value
                                                    );

                    $oMail_User             = new c_Mail_User;
                    $oMail_User->Type       = 1;
                    $oMail_User->Subject    = "Your Account Password";
                    $oMail_User->Content    = $Variables;

                    try {
                        if (config('var.SEND_AUTO_ACCESSDATA')) {
                            Mail::to($Request->input("User_Email"))->send($oMail_User);
                        } else {
                            Mail::to(config('var.SEND_EMAIL_ACCESSDATA'))->send($oMail_User);
                        }
                    } catch (Throwable $ex) {}
                }


            } else {
                $Id_User    = $Request->input("Id_User");
            }
            #endregion

            //
            //  DESERIALIZA DATOS DE LA RESERVA
            //
            $oBooking   = json_decode($Request->input("Booking"));

            for ($k = 0; $k < count($oBooking); $k++) {
                #region BOOKIN

                $oParam         = array(    $oBooking[$k]->Booking_DateStart,
                                            $oBooking[$k]->Booking_Receipt,
                                            2,
                                            '',
                                            $oBooking[$k]->Id_Language,
                                            $oBooking[$k]->Id_GuideLanguage,
                                            $Id_User,
                                            $oBooking[$k]->Booking_InPerson,
                                            $Request->header("Token")
                                        );
                $oData_Booking  = DB::select('call sp_booking_insert(?,?,?,?,?,?,?,?,?)', $oParam);
                
                #endregion

                $oPassenger     = $oBooking[$k]->Passenger;
                $oTour          = $oBooking[$k]->Tour;

                if ($oData_Booking[0]->Response_Success == 1) {
                    $Id_Booking = $oData_Booking[0]->Response_Id;
                    $oData = $oData_Booking;

                    #region INSERTA PASSENGER

                    for ($j=0; $j < count($oPassenger); $j++) {
                        $oParam = array(
                                 Str::title($oPassenger[$j]->Passenger_Name),
                                 Str::title($oPassenger[$j]->Passenger_LastName),
                                            $oPassenger[$j]->Passenger_Email,
                                            $oPassenger[$j]->Passenger_Phone,
                                            $oPassenger[$j]->Passenger_Gender,
                                            $oPassenger[$j]->Passenger_DOB,
                                Str::upper(trim($oPassenger[$j]->Passenger_NoDocument)),
                                            $oPassenger[$j]->Passenger_Restriction,
                                            $oPassenger[$j]->Passenger_Extras,
                                            2,
                                            $Id_Booking,
                                            $oPassenger[$j]->Id_TypeDocument,
                                            $oPassenger[$j]->Id_TypeRate,
                                            $oPassenger[$j]->Id_UserCountry
                                        );
        
                        $oData_Passenger = DB::select('call sp_passenger_insert(?,?,?,?,?,?,?,?,?,?,?,?,?,?)', $oParam);
                        if ($oData_Passenger[0]->Response_Success == 0) {
                            $oData = $oData_Passenger;
                            break;
                        }
                    }

                    #endregion
                    
                    #region LISTA LOS PASAJEROS DE UNA RESERVA

                    $Path_ImgDocument1_Thumb    = config("var.PATH_PUBLIC").config("var.PASSENGER_IMGDOCUMENT1_THUMB");
                    $Path_ImgDocument1_Large    = config("var.PATH_PUBLIC").config("var.PASSENGER_IMGDOCUMENT1_LARGE");
                    $Path_ImgDocument2_Thumb    = config("var.PATH_PUBLIC").config("var.PASSENGER_IMGDOCUMENT2_THUMB");
                    $Path_ImgDocument2_Large    = config("var.PATH_PUBLIC").config("var.PASSENGER_IMGDOCUMENT2_LARGE");

                    $oParam = array(    "all",
                                        $Id_Booking,
                                        0,
                                        $Path_ImgDocument1_Thumb,
                                        $Path_ImgDocument1_Large,
                                        $Path_ImgDocument2_Thumb,
                                        $Path_ImgDocument2_Large
                                    );
        
                    $oPassenger = DB::select('call sp_passenger_list(?,?,?,?,?,?,?)', $oParam);
                    
                    #endregion
                    #region INSERTA TOUR / UPGRADES / EXTRAS / EQUIPMENT
                    for($j = 0; $j < count($oTour); $j++) {
                        #region TOUR

                        $oParam = [
                            $oTour[$j]->BookingTour_DateStart,
                            $oBooking[$k]->Booking_Type,
                            $oBooking[$k]->Booking_NoPax,
                            $oBooking[$k]->Id_Package,
                            $Id_Booking,
                            $oTour[$j]->Id_Tour,
                            1
                        ];
                        $oData_Tour     = DB::select('call sp_booking_tour_insert(?,?,?,?,?,?,?)', $oParam);
                        #endregion
                        $Id_BookingTour = $oData_Tour[0]->Response_Id;
                        $oUpgrade       = $oTour[$j]->Upgrade;
                        $oExtra         = $oTour[$j]->Extra;
                        $oEquipment     = $oTour[$j]->Equipment;

                        #region INSERTA BOOKING TOUR PASSENGER

                        for($h = 0; $h < count($oPassenger); $h++){

                            $oParam                 = array(    $Id_BookingTour,
                                                                $oPassenger[$h]->Id_Passenger,
                                                                count($oPassenger)
                                                            );

                            $data = DB::select('SELECT  `Id_Package`,       `BookingTour_Type`,     `Id_User`
                            FROM    `t_booking_tour`    AS `bt` JOIN
                                    `t_booking`         AS  `b` ON `b`.`Id_Booking` = `bt`.`Id_Booking`
                            WHERE   `Id_BookingTour`    = ?',[$Id_BookingTour])[0];
                            $oData_TourPassenger    = DB::select('call sp_booking_tour_passenger_insert(?,?,?)',$oParam);
                        }

                        #endregion

                        #region RECUPERA LOS PASAJEROS DEL TOUR

                        $oParam = array(    "all",
                                            $Id_BookingTour,
                                            0,
                                            ''
                                        );
                                    
                        $oTourPassenger = DB::select('call sp_booking_tour_passenger_list(?,?,?,?)',$oParam);

                        #endregion

                        
                        $Id_BookingTour = $oData_Tour[0]->Response_Id;
                        $oUpgrade       = $oTour[$j]->Upgrade;
                        $oExtra         = $oTour[$j]->Extra;
                        $oEquipment     = $oTour[$j]->Equipment;
                        
                        #region BOOKING UPGRADE

                        for($i = 0; $i < count($oUpgrade); $i++){

                            #region BOOKING UPGRADE

                            $oParam             = array(    $oBooking[$k]->Booking_NoPax,
                                                            "",
                                                            1,
                                                            $Id_BookingTour,
                                                            0,
                                                            $oUpgrade[$i]->Id_Upgrade,
                                                            1,
                                                            1
                                                        );
                        
                            $oData_Upgrade      = DB::select('call sp_booking_upgrade_insert(?,?,?,?,?,?,?,?)',$oParam);
                            $Id_BookingUpgrade  = $oData_Upgrade[0]->Response_Id;

                            #endregion
                            
                            #region BOOKING UPGRADE PASSENGER

                            for ($h = 0; $h < count($oTourPassenger); $h++) {

                                $oParam                     = [
                                    $Id_BookingUpgrade,
                                    $oTourPassenger[$h]->Id_BookingTourPassenger,
                                    1
                                ];
                                $oData_UpgradePassenger     = DB::select('call sp_booking_upgrade_passenger_insert(?,?,?)', $oParam);
                            }

                            #endregion
                        }

                        #endregion

                        #region BOOKING EXTRA

                        for($i = 0; $i < count($oExtra); $i++){

                            #region BOOKING EXTRA

                            $oParam             = array(    $oBooking[$k]->Booking_NoPax,
                                                            " ",
                                                            1,
                                                            $Id_BookingTour,
                                                            0,
                                                            $oExtra[$i]->Id_Extra,
                                                            1,
                                                            1
                                                        );
                        
                            $oData_Extra        = DB::select('call sp_booking_extra_insert(?,?,?,?,?,?,?,?)',$oParam);
                            $Id_BookingExtra    = $oData_Extra[0]->Response_Id;
                                    
                            #endregion

                            #region BOOKING EXTRA PASSENGER

                            for($h = 0; $h < count($oTourPassenger); $h++){

                                $oParam                 = array(    $Id_BookingExtra,
                                                                    $oTourPassenger[$h]->Id_BookingTourPassenger,
                                                                    1
                                                                );
                            
                                $oData_ExtraPassenger   = DB::select('call sp_booking_extra_passenger_insert(?,?,?)',$oParam);
                            }

                            #endregion

                        }

                        #endregion

                        #region BOOKING EQUIPMENT

                        for ($i=0; $i < count($oEquipment); $i++) { 
                            
                            #region BOOKING EQUIPMENT

                            $oParam     =   [
                                                $oEquipment[$i]->BookingEquipment_Quantity,
                                                1,
                                                $Id_BookingTour,
                                                $oEquipment[$i]->Id_Equipment,
                                                1,
                                                1
                                            ];
                        
                            $oData_Equipment        = DB::select('call sp_booking_equipment_insert(?,?,?,?,?,?)',$oParam);
                            $Id_BookingEquipment    = $oData_Equipment[0]->Response_Id;

                            #endregion

                            #region BOOKING EXTRA PASSENGER

                            for($h = 0; $h < count($oTourPassenger); $h++){

                                $oParam                 = array(    $Id_BookingEquipment,
                                                                    $oTourPassenger[$h]->Id_BookingTourPassenger,
                                                                    1,
                                                                    ""
                                                                );
                            
                                $oData_EquipmentPassenger   = DB::select('call sp_booking_equipment_passenger_insert(?,?,?,?)',$oParam);
                            }

                            #endregion
                        
                        }

                        DB::select ('CALL sp_booking_tour_add_items_from_package_tour(?,?)', [ $Id_BookingTour,1 ]);

                        #endregion
                    }

                    #endregion
                
                    #region INVOICE

                    for($i = 0; $i < count($oPassenger); $i++){
                        $oParam         = array(    $Id_Booking,
                                                    $oPassenger[$i]->Id_Passenger,
                                                    1
                                                );

                        $oData_Invoice  = DB::select('call sp_invoice_insert(?,?,?)',$oParam);
                        $oData          = $oData_Invoice;
                    }

                    #endregion
                    
                    //BookingMailSender::sendBookingByMail ($Id_Booking, $this->oDomain);

                    $this->history->insert (
                        self::getHistoryData($Id_Booking),
                        $Request,
                        $Id_Booking,
                        false
                    );
                
                }else{
                    $oData = $oData_Booking;
                    break;
                }
            }

            $oResponse["Response_Status"]           = $oData[0]->Response_Status;
            $oResponse["Response_Code"]             = $oData[0]->Response_Code;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $oData[0]->Response_Message;
            $oResponse["Response_Data"]             = null;
            $oResponse["Response_Error_Message"]    = $oData[0]->Response_Message;
            $oResponse["Response_Error_Reason"]     = $oData[0]->Response_Reason;
        }

        return ResponseBuilder::Response($oResponse);
    }

    public function SendMail (Request $Request, $Id)
    {
        
        $oResponse = ParamsValidator::Validate_Id($Id,$this->oDomain);
        
        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
            $test = false;
            if ($test) {
                return BookingMailSender::sendBookingByMail($Id, $this->oDomain, BookingMailSender::ONLY_REGULAR, $test);
            } else {
                $oResponse = BookingMailSender::sendBookingByMail($Id, $this->oDomain);
            }
            
        }
        
        return ResponseBuilder::Response($oResponse);
    }

    public function Update(Request $Request)
    {
        $oResponse  = array();

        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Request($Request, BookingValidators::UPDATE, $this->oDomain);
        
        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
            $this->history->obtainOld($Request->input('Id_Booking'));
            
            $oParam = array(    $Request->input("Id_Booking"),
                                $Request->input("Booking_DateBriefing"),
                                $Request->input("Booking_PlaceBriefing"),
                                $Request->input("Booking_Hotel"),
                                $Request->input("Booking_Observation"),
                                $Request->input("Booking_InPerson"),
                                $Request->input("Id_Language"),
                                $Request->input("Id_GuideLanguage"),
                                $Request->input("Id_BookingRelationship"),
                                $Request->input("Id_BookingReferredFrom")
                            );
            $oData = DB::select('call sp_booking_update(?,?,?,?,?,?,?,?,?,?)', $oParam);

            //  RESPONSE
            if ($oData[0]->Response_Success == 1) {
                #region LISTA LOS PASAJEROS DE UNA RESERVA

                $Path_ImgDocument1_Thumb    = config("var.PATH_PUBLIC").config("var.PASSENGER_IMGDOCUMENT1_THUMB");
                $Path_ImgDocument1_Large    = config("var.PATH_PUBLIC").config("var.PASSENGER_IMGDOCUMENT1_LARGE");
                $Path_ImgDocument2_Thumb    = config("var.PATH_PUBLIC").config("var.PASSENGER_IMGDOCUMENT2_THUMB");
                $Path_ImgDocument2_Large    = config("var.PATH_PUBLIC").config("var.PASSENGER_IMGDOCUMENT2_LARGE");

                $oParam = [
                    "all",
                    $Request->input("Id_Booking"),
                    0,
                    $Path_ImgDocument1_Thumb,
                    $Path_ImgDocument1_Large,
                    $Path_ImgDocument2_Thumb,
                    $Path_ImgDocument2_Large
                ];

                $oPassenger = DB::select('call sp_passenger_list(?,?,?,?,?,?,?)', $oParam);
                
                #endregion

                #region ACTUALIZA LOS INVOICES DE LOS PASAJEROS
                
                for ($i=0; $i < count($oPassenger); $i++) {
                    $oParam     = array(    $oPassenger[$i]->Id_Passenger,
                                            1
                                        );

                    $oInvoice   = DB::select('call sp_invoice_reload(?,?)' ,$oParam);
                }

                $this->history->update(
                    $Request->input('Id_Booking'),
                    $this->history->oldValue,
                    [$Request->all()],
                    $Request
                );

                #endregion
                
            }else{
                
            }
            
            $oResponse["Response_Status"]           = $oData[0]->Response_Status;
            $oResponse["Response_Code"]             = $oData[0]->Response_Code;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $oData[0]->Response_Message;
            $oResponse["Response_Data"]             = null;
            $oResponse["Response_Error_Message"]    = $oData[0]->Response_Message;
            $oResponse["Response_Error_Reason"]     = $oData[0]->Response_Reason;
        }

        return ResponseBuilder::Response($oResponse);

    }
        
    public function UpdateAdmin(Request $Request)
    {
        $oResponse  = array();
        $oValParams = array(    'Id_Booking'                => 'required|int',
                                'Id_Admin'                  => 'required|int'
                            );


        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Request($Request,$oValParams,$this->oDomain);
        
        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
            $this->history->obtainOld($Request->input('Id_Booking'));

            $oParam = array(                $Request->input("Id_Booking"),
                                            $Request->input("Id_Admin"),
                            );
            $oData = DB::select('call sp_booking_update_admin(?,?)',$oParam);

            //  RESPONSE
            if($oData[0]->Response_Success == 1) {
                $this->history->update (
                    $Request->input('Id_Booking'),
                    $this->history->oldValue,
                    [$Request->all()],
                    $Request
                );
            }else{
                
            }
            
            $oResponse["Response_Status"]           = $oData[0]->Response_Status;
            $oResponse["Response_Code"]             = $oData[0]->Response_Code;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $oData[0]->Response_Message;
            $oResponse["Response_Data"]             = null;
            $oResponse["Response_Error_Message"]    = $oData[0]->Response_Message;
            $oResponse["Response_Error_Reason"]     = $oData[0]->Response_Reason;
        }

        return ResponseBuilder::Response($oResponse);

    }

    public function Upgrade(Request $Request)
    { 
        $continue   = true;
        $oResponse  = array();
        $oValParams = array(    'Id_Booking'        => 'required|int',
                                'Id_Package'        => 'required|int',
                                'Id_BookingTour'    => 'required|int',
                                'Group'             => 'required|int',
                                'Tour_value'        => 'required|string',
                                'BookingTour_ValueOld'  => 'required|string'
                            );

 
        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Request($Request,$oValParams,$this->oDomain);
        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {

            $lastBookingTour = DB::select ('CALL sp_booking_tour_list_by_group(?,?)', [ $Request->input("Id_Booking"), $Request->input("Group") ]);
        
            $BookingTour_Value      = json_decode ($Request->input("Tour_value"));
            $BookingTour_ValueOld   = json_decode ($Request->input('BookingTour_ValueOld'));

            for($i = 0; $i < count($BookingTour_Value); $i++){

                $oParam = array(    $BookingTour_Value[$i]->BookingTour_DateStart,
                                    $BookingTour_Value[$i]->Id_BookingTour,
                                    $BookingTour_Value[$i]->Id_Tour
                                );
                $oDataTour = DB::select('call sp_booking_tour_clone(?,?,?)',$oParam);

                if($oDataTour[0]->Response_Success == 0){
                    $oData      = $oDataTour;
                    $continue   = false;
                    break ;
                }
                
            }

            if ($continue == true) {

                
                $oParam = array(    $Request->input("Id_Booking"),
                                    $Request->input("Id_Package"),
                                    $Request->input("Group")
                                );
                $oData = DB::select('call sp_booking_tour_upgrade(?,?,?)',$oParam);
                

                #region LISTA TODOS LOS PASAJEROS DEL BOOKING TOUR

                $Path_Thumb     = config("var.PATH_PUBLIC").config("var.USER_COUNTRY_THUMB");
                $oParam         = array(    'all',
                                            $Request->input("Id_BookingTour"),
                                            0,
                                            $Path_Thumb
                                        );
                                
                $oDataPax  = DB::select('call sp_booking_tour_passenger_list(?,?,?,?)',$oParam);

                #endregion
                
                for($i = 0; $i < count($oDataPax); $i++){
                    #region ACTUALIZA LOS PRECIOS

                    $oParam     = array(    $Request->input("Id_BookingTour"),
                                            $oDataPax[$i]->Id_Passenger,
                                            count($oDataPax),
                                            1
                                         );
                    $oDataTour  = DB::select('call sp_booking_tour_passenger_price(?,?,?,?)',$oParam);
                    
                    #endregion

                    #region ACTUALIZA EL INVOICE

                    $oParam     = array( $oDataPax[$i]->Id_Passenger, 1 );
                    $oDataTour  = DB::select('call sp_invoice_reload(?,?)',$oParam);

                    #endregion
        
                    if($oDataTour[0]->Response_Success == 0){
                        $oData=$oDataTour;
                        $continue=false;
                        break ;
                    }
                }

            }
            
            

            if ($continue == true) {
                $bookingTourList = DB::select ('CALL sp_booking_tour_list_by_group(?,?)',
                    [
                        $Request->input("Id_Booking"),
                        $Request->input("Group")
                    ]
                );
                
                foreach ($bookingTourList as $bookingTour) {
                    DB::select ('CALL sp_booking_tour_add_items_from_package_tour(?,?)', [ $bookingTour->Id_BookingTour, 1 ]);
                }

                $this->historyBookingTour->update (
                    $Request->input('Id_Booking'),
                    $lastBookingTour,
                    $bookingTourList,
                    $Request
                );

                $oData = array(
                    array(
                        "Response_Status"   => 200,
                        "Response_Code"     => 200,
                        "Response_Message"  => "Paquete remplazado con éxito",
                        "Response_Reason"   => null
                    )
                );

                $oData = json_decode(json_encode($oData));
            }
            
            
            $oResponse["Response_Status"]           = $oData[0]->Response_Status;
            $oResponse["Response_Code"]             = $oData[0]->Response_Code;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $oData[0]->Response_Message;
            $oResponse["Response_Data"]             = null;
            $oResponse["Response_Error_Message"]    = $oData[0]->Response_Message;
            $oResponse["Response_Error_Reason"]     = $oData[0]->Response_Reason;
        }

        return ResponseBuilder::Response($oResponse);

    }

    public function Status(Request $Request)
    {
        $oResponse  = array();
        $oValParams = array(    'Id_Booking'        => 'required|int',
                                'Booking_Status'    => 'required|int'
                            );
        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Request($Request, $oValParams, $this->oDomain);
        
        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
            $this->history->obtainOld($Request->input("Id_Booking"));
            $oParam = array(    $Request->input("Id_Booking"),
                                $Request->input("Booking_Status"),
                                $Request->header('Token')
                            );
            $oData  = DB::select('call sp_booking_status(?,?,?)', $oParam);

            //  RESPONSE
            if ($oData[0]->Response_Success == 1) {
                $this->history->update(
                    $Request->input('Id_Booking'),
                    $this->history->oldValue,
                    [$Request->all()],
                    $Request
                );
            } else {
            }
            
            $oResponse["Response_Status"]           = $oData[0]->Response_Status;
            $oResponse["Response_Code"]             = $oData[0]->Response_Code;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $oData[0]->Response_Message;
            $oResponse["Response_Data"]             = null;
            $oResponse["Response_Error_Message"]    = $oData[0]->Response_Message;
            $oResponse["Response_Error_Reason"]     = $oData[0]->Response_Reason;
        }

        return ResponseBuilder::Response($oResponse);
    }

    public function Delete(Request $request)
    {
        
        if ($oResponse = BookingDeleter::validateInput($request, $this->oDomain)) {
            return ResponseBuilder::Response($oResponse);
        }

        $this->history->obtainOld($request->input("Id_Booking"));
        
        $oData = DB::select('CALL sp_booking_delete(?,?,?)', [
            $request->header('Token'),
            $request->input('Id_Booking'),
            $request->input('Booking_Create'),
        ]);
        
        if ($oData[0]->Response_Success == 1) {
            $this->history->update(
                $request->input('Id_Booking'),
                $this->history->oldValue,
                [$request->all()],
                $request
            );
        } else {
        }

        $oResponse = [];
        $oResponse["Response_Status"]           = $oData[0]->Response_Status;
        $oResponse["Response_Code"]             = $oData[0]->Response_Code;
        $oResponse["Response_Domain"]           = $this->oDomain;
        $oResponse["Response_Message"]          = $oData[0]->Response_Message;
        $oResponse["Response_Data"]             = [
            'Response_Id' => $oData[0]->Response_Id
        ];
        $oResponse["Response_Error_Message"]    = $oData[0]->Response_Message;
        $oResponse["Response_Error_Reason"]     = $oData[0]->Response_Reason;
        
        return ResponseBuilder::Response($oResponse);
    }
        

    public function Index(Request $Request, $Id)
    {
        $oResponse  = array();

        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Id($Id, $this->oDomain);
        
        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {       
            $oParam     = array( $Id );
            $oData      = DB::select('call sp_booking_index(?)',$oParam);
            
            if(count($oData)>0){
                    
                $oParam             = array( $Id );
                $oDataTour          = DB::select('call sp_booking_tour_list(?)',$oParam);
                $oData[0]->Tour     = $oDataTour;
            }
            
            $oResponse["Response_Status"]           = 200;
            $oResponse["Response_Code"]             = 200;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $this->oDomain." Index";
            $oResponse["Response_Data"]             = $oData;
            $oResponse["Response_Error_Message"]    = "";
            $oResponse["Response_Error_Reason"]     = "";
        }

        return ResponseBuilder::Response($oResponse);
    }

    public static function getReportData($Id_Booking, $invoiceListJSON)
    {
        return self::mapBookingList(self::getBookingIndex($Id_Booking), $invoiceListJSON);
    }

    public static function mapBookingList($bookingList, $invoiceListJSON)
    {
        return array_map(
            function ($booking) use ($invoiceListJSON) {

                $booking->Tour              = self::mapTourList(DB::select('call sp_booking_tour_list_report(?)', [$booking->Id_Booking]));
                $booking->Invoice           = self::mapInvoiceList(self::getInvoiceList($booking->Id_Booking));
                $booking->UserCountry_Path  = config('var.PATH_PUBLIC') . config('var.USER_COUNTRY_THUMB');

                $passengerParams            = [
                    "all",
                    $booking->Id_Booking,
                    0,
                    "",
                    "",
                    "",
                    "",
                    config('var.PATH_PUBLIC') . config("var.USER_COUNTRY_THUMB")
                ];
                $booking->Passengers        = DB::select( 'call sp_passenger_list_report(?,?,?,?,?,?,?,?)', $passengerParams );

                $booking->Flight            = self::mapFlightList( DB::select('call sp_flight_list(?)', [ $booking->Id_Booking ]) );
                $booking->Room              = self::mapRoomList (DB::select('call sp_room_list(?)', [ $booking->Id_Booking ]));
                $booking->InvoiceDetailAll  = c_Invoice_Detail::GetAll($invoiceListJSON)["Invoices"];
                $booking->Invoice_FeeAll    = c_Invoice_Fee::GetAll($invoiceListJSON);
                $booking->PayAll            = CashMovementDetail::getAll($invoiceListJSON);
                $booking->InvoiceRes        = c_Invoice::GetAll($invoiceListJSON);
                return $booking;
            },
            $bookingList
        );
    }

    public static function mapBookingUpgradeList($bookingUpgradeList)
    {
        return self::mapBookingItemList($bookingUpgradeList, 'Upgrade');
    }

    public static function mapBookingExtraList($bookingExtraList)
    {
        return self::mapBookingItemList($bookingExtraList, 'Extra');
    }

    public static function mapBookingEquipmentList($bookingEquipmentList)
    {
        return self::mapBookingItemList($bookingEquipmentList, 'Equipment');
    }

    public static function mapBookingItemList($bookingItemList, $itemType)
    {
        return array_map (function ($bookingItem) use ($itemType) {
            $ltype = strtolower($itemType);
            $typeName = 'Id_Booking' . $itemType;
            $bookingItem->Pax = DB::select("call sp_booking_{$ltype}_passenger_list(?)", [$bookingItem->$typeName]);
            return $bookingItem;
        }, $bookingItemList);
    }

    public static function mapTourList($tourList)
    {
        return array_map(
            function ($tour) {
                $params = [ 'all',$tour->Id_BookingTour,0,'' ];
                $tour->Passengers = DB::select('call sp_booking_tour_passenger_list(?,?,?,?)', $params);

                $tour->Upgrades     = self::mapBookingUpgradeList(DB::select('call sp_booking_upgrade_list(?)', [$tour->Id_BookingTour]));
                $tour->Extras       = self::mapBookingExtraList (DB::select('call sp_booking_extra_list(?)', [$tour->Id_BookingTour]));
                $tour->Equipments   = self::mapBookingEquipmentList (DB::select('call sp_booking_equipment_list(?)', [$tour->Id_BookingTour]));
                
                return $tour;
            },
            $tourList
        );
    }

    public static function mapRoomList($roomList)
    {
        return array_map(function ($room) {
            $room->Passengers = DB::select('call sp_room_passenger_list(?)', [ $room->Id_Room ]);
            return $room;
        }, $roomList);
    }

    public static function mapFlightList($flightList)
    {
        return array_map(function ($flight) {
            $flight->Passengers = DB::select('call sp_flight_passenger_list(?)', [ $flight->Id_Flight ]);
            return $flight;
        }, $flightList);
    }

    public static function mapInvoiceList($invoiceList) {
        return array_map (
            function($invoice) {
                $invoice->Invoice_Detail    = DB::select('call sp_invoice_detail_list(?)',  [ $invoice->Id_Invoice ]);
                $invoice->Invoice_Fee       = DB::select('call sp_invoice_fee_list(?)',     [ $invoice->Id_Invoice ]);
                return $invoice;
            },
            $invoiceList
        );
    }
        
    public static function getInvoiceList($Id_Booking) {
        return DB::select('call sp_invoice_list(?,?)', [ $Id_Booking, '' ]);
    }

    public static function getBookingIndex($Id_Booking) {
        return DB::select('call sp_booking_index(?)', [$Id_Booking]);
    }

    public function GetReport(Request $Request)
    {
        $oResponse  = array();

        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Request(
            $Request,
            [
                'Id_Booking'    =>  'required|int',
                'Invoices'      =>  'required|string',
            ],
            $this->oDomain
        );

        if ($oResponse["Response_Code"] == 200) {
            $Id     = $Request->input('Id_Booking') ;
            $oParam     = array( $Id );
            $oData      = self::mapBookingList(
                DB::select('call sp_booking_index(?)', $oParam),
                $Request->input('Invoices')
            );

            $oResponse["Response_Status"]           = 200;
            $oResponse["Response_Code"]             = 200;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $this->oDomain." list ";
            $oResponse["Response_Data"]             = $oData;
            $oResponse["Response_Error_Message"]    = "";
            $oResponse["Response_Error_Reason"]     = "";
        }

        return ResponseBuilder::Response($oResponse);
    }

    public function Search(Request $Request)
    {
        $oResponse  = array();
        //return $Request;
        $oValParams = array(    'Text'              => 'string',
                                'Date_Start'        => 'required|string',
                                'Date_End'          => 'required|string',
                                'Booking_Type'      => 'required|int',
                                'Booking_Status'    => 'required|int',
                                'User_Type'         => 'required|int'
                            );

        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Request($Request, $oValParams, $this->oDomain);
        
        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
            $oParam = array(    $Request->input("Text"),
                                $Request->input("Date_Start"),
                                $Request->input("Date_End"),
                                $Request->input("Booking_Type"),
                                $Request->input("Booking_Status"),
                                $Request->header("Token"),
                                $Request->ip(),
                                $Request->input("User_Type"),
                                config('var.PATH_PUBLIC').config("var.USER_COUNTRY_THUMB")
                            );

            $oData  = DB::select('call sp_booking_search(?,?,?,?,?,?,?,?,?)', $oParam);
            $oData = (new BookingPackSearch())->__invoke($oData);

            $oResponse["Response_Status"]           = 200;
            $oResponse["Response_Code"]             = 200;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $this->oDomain." list ";
            $oResponse["Response_Data"]             = $oData;
            $oResponse["Response_Error_Message"]    = "";
            $oResponse["Response_Error_Reason"]     = "";
        }
        return ResponseBuilder::Response($oResponse);
    }

    public function SearchDay(Request $Request)
    {
        (new LaravelValidator)->validate($Request->all(), $this->oDomain, BookingValidators::SEARCH_DATE);
        
        $oParam = [
            $Request->input("Date_Start"),
            $Request->input("Date_End"),
            $Request->input("Booking_Status"),
            $Request->header("Token"),
            $Request->ip(),
            config('var.PATH_PUBLIC').config("var.USER_COUNTRY_THUMB")
        ];

        $oData  = DB::select('call sp_booking_search_date(?,?,?,?,?,?)', $oParam);
        $oData = (new BookingPackSearch())->__invoke($oData);

        $oResponse = [
            "Response_Status"           => 200,
            "Response_Code"             => 200,
            "Response_Domain"           => $this->oDomain,
            "Response_Message"          => $this->oDomain." list ",
            "Response_Data"             => $oData,
            "Response_Error_Message"    => "",
            "Response_Error_Reason"     => "",
        ];

        return ResponseBuilder::Response($oResponse);
    }

    public function Search_Passenger(Request $Request){
        $oResponse  = array();
        
        $oValParams = array(    'Text'          => 'string',
                                'Date_Start'    => 'required|string',
                                'Date_End'      => 'required|string'
                            );

        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Request($Request,$oValParams,$this->oDomain);
        
        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
            $oParam = [
                $Request->input("Text"),
                $Request->header("Token"),
                config('var.PATH_PUBLIC').config("var.USER_COUNTRY_THUMB"),
            ];
            $oData  = DB::select('call sp_booking_passenger_search(?,?,?)',$oParam);

            $oResponse["Response_Status"]           = 200;
            $oResponse["Response_Code"]             = 200;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $this->oDomain." list ";
            $oResponse["Response_Data"]             = $oData;
            $oResponse["Response_Error_Message"]    = "";
            $oResponse["Response_Error_Reason"]     = "";
        }

        return ResponseBuilder::Response($oResponse);
    }

    public function History_List(Request $Request,$Id){
        $oResponse  = array();

        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Id($Id,$this->oDomain);
        
        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {       
            $oParam = array( $Id );
            $oData  = DB::select('call sp_booking_history_list(?)',$oParam);
            
            $oResponse["Response_Status"]           = 200;
            $oResponse["Response_Code"]             = 200;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $this->oDomain." Index";
            $oResponse["Response_Data"]             = $oData;
            $oResponse["Response_Error_Message"]    = "";
            $oResponse["Response_Error_Reason"]     = "";
        }

        return ResponseBuilder::Response($oResponse);
    }

    public function CalendarPax(Request $Request){
        $oResponse  = array();
        $oValParams     = array(    'Id_tour'       => 'required|string|max:20',
                                    'Month'         => 'required|int',
                                    'Year'          => 'required|int'
                                );

        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Request($Request,$oValParams,$this->oDomain);
        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
          
            #region RETORNA CANTIDAD DE CUPOS OCUPADOS

            $oParam     = array(    $Request->input("Id_tour"),
                                    $Request->input("Month"),
                                    $Request->input("Year"),
                                    $Request->header("Token")
                                );
            
            $oAvial  = DB::select('call sp_tour_availability_calendar(?,?,?,?)',$oParam);

            $admin = DB::select ('CALL sp_admin_index_token(?)', [$Request->header('Token')]);
            #endregion

            #region RECUPERA DATOS DEL TOUR

            $oParam     = array(    $Request->input("Id_tour") );

            $oTour = DB::select('call sp_tour_index(?)',$oParam);
            
            #endregion

            #region DETERMINA LA CANTIDAD DE DIAS DE UNA FECHA
              
            $dias = cal_days_in_month(CAL_GREGORIAN,  $Request->input("Month"), $Request->input("Year")); 
            
            #endregion


            $oData          = array();
            
            for($k = 0; $k < $dias; $k++){
                   
                $paxdisponible = $oTour[0]->Tour_Availability;
                
                for($j = 0; $j < count($oAvial); $j++){
                
                    if( $oAvial[$j]->BookingTour_DateStart == date("Y-m-d", strtotime($Request->input("Year").'-'.$Request->input("Month").'-'.($k+1)))){
                        
                        $paxdisponible = $paxdisponible - $oAvial[$j]->pax;
                    }
                }
                
                $oData[$k] = [  "date"      => date("Y-m-d", strtotime($Request->input("Year") . '-' . $Request->input("Month") . '-' . ($k+1))),
                                "paxFree"   => $paxdisponible,
                                "Aviav"     => $oTour[0]->Tour_Availability,
                                "Admin"     => $admin[0]->AdminRole_Admin
                    ];    
            }

            
            $oResponse["Response_Status"]           = 200;
            $oResponse["Response_Code"]             = 200;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $this->oDomain." Index ";
            $oResponse["Response_Data"]             = $oData;
            $oResponse["Response_Error_Message"]    = "";
            $oResponse["Response_Error_Reason"]     = "";
        }
        return ResponseBuilder::Response($oResponse);
    }

    public function CalendarCategory(Request $Request){
        $oResponse  = array();
        $oValParams     = array(    'Id_CategoryTour'   => 'required|int',
                                    'Id_tour'           => 'required|int',
                                    'Month'             => 'required|int',
                                    'Year'              => 'required|int'
                                );

        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Request($Request,$oValParams,$this->oDomain);
        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {

            $oData= [(object)[]];
            #region RETORNA LA CANTIDAD DE TOURS QUE TIENE UNA CATEGORIA

            $oParam     = array(
                $Request->input("Id_CategoryTour"),
                'all'
            );
            
            $oData[0]->tours  = DB::select('call sp_tour_list_category(?, ?)',$oParam);

            #endregion
          
            if(count($oData[0]->tours)==0){
                $oParam     = array(    1,
                                        $Request->input("Month"),
                                        $Request->input("Year"),
                                        $Request->header("Token")
                                    );
                
                $oAvial = DB::select('call sp_tour_availability_calendar(?,?,?,?)',$oParam);

            }else{
                #region RETORNA CANTIDAD DE CUPOS OCUPADOS
                if($Request->input("Id_tour")<=0){
                    
                    for($k = 0; $k < count($oData[0]->tours) ; $k++){
                        $oParam     = array(    $oData[0]->tours[$k]->Id_Tour,
                                                $Request->input("Month"),
                                                $Request->input("Year"),
                                                $Request->header("Token")
                                            );
                        
                        $oAvial  = DB::select('call sp_tour_availability_calendar(?,?,?,?)',$oParam);
                        $oData[0]->tours[$k]->date=$oAvial;
                    }
                    // $oParam = [
                    //          $Request->input("Id_CategoryTour"),
                    //          $Request->input("Month"),
                    //          $Request->input("Year"),
                    //          $Request->header("Token")
                    //      ];
                    // $oAvial = DB::select('call sp_category_tour_availability_calendar(?,?,?,?)', $oParam);
                    // $oData[0]->tours = array_map(function($item) use ($oAvial) {
                    //  return (object)[
                    //      'Tour_Name'         => $item->Tour_Name,
                    //      'Tour_Color'        => $item->Tour_Color,
                    //      'date'              => $oAvial
                    //  ];
                    // }, $oAvial);
                }else{
                    $oParam     = array(    $Request->input("Id_tour"),
                                            $Request->input("Month"),
                                            $Request->input("Year"),
                                            $Request->header("Token")
                                        );
                    $oAvial  = DB::select('call sp_tour_availability_calendar(?,?,?,?)',$oParam);   

                     
                    $oData[0]->tours=array_values (array_filter ($oData[0]->tours, function ($tour)use ($Request) { return $tour->Id_Tour == $Request->input("Id_tour"); }));
                    $oData[0]->tours[0]->date=$oAvial;

                }
                // $oData[0]->days  = $oAvial;
            }
            
            #endregion

            #region DETERMINA LA CANTIDAD DE DIAS DE UNA FECHA
              
            $dias = cal_days_in_month(CAL_GREGORIAN,  $Request->input("Month"), $Request->input("Year")); 
            $sum=0;
            $cant=0;
            $tourwpax=0;
            $val=0;
            $value=0;
            #endregion
            

            #region DETERMINA LA CANTIDAD DE RESERBAS POR  CATEGORIA
            
            $oData[0]->days   = array();
            $datepru="";
            $oDataTours = array();
            for($k = 0; $k < $dias; $k++){
                $sum = 0;
                foreach ($oData[0]->tours as $tour) {
                    $cant = 0;
                    for($j = 0; $j < count($tour->date); $j++){
                        if( $tour->date[$j]->BookingTour_DateStart == date("Y-m-d", strtotime($Request->input("Year").'-'.$Request->input("Month").'-'.($k+1)))){
                            $cant = $tour->date[$j]->pax;
                            $sum += $cant;
                            $tourwpax++;
                        }
                    }
                    if($cant>0){
                        $val++;
                        $value=$val;
                    }else{
                        $value=0;
                    }
                    array_push($oDataTours, array (
                        'name' => $tour->Tour_Name,
                        'paxs' => $cant,
                        'color'=> $tour->Tour_Color,
                        'value'=> $value
                    ));
                }
                    
                $oData[0]->days[$k] = [ "date"      => date("Y-m-d", strtotime($Request->input("Year").'-'.$Request->input("Month").'-'.($k+1))),
                                        "pax"       => $sum,
                                        "tours"     => $oDataTours,
                                        "tourWPax"  => $tourwpax
                                    ];  
                $datepru="";  
                $sum=0;
                $tourwpax=0;
                $val=0;
                $oDataTours = array();
            }
            #endregion

            $oResponse["Response_Status"]           = 200;
            $oResponse["Response_Code"]             = 200;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $this->oDomain." Index ";
            $oResponse["Response_Data"]             = $oData;
            $oResponse["Response_Error_Message"]    = "";
            $oResponse["Response_Error_Reason"]     = "";
        }
        return ResponseBuilder::Response($oResponse);
    }

    public function CalendarCategoryPaxs(Request $Request)
    {
        $oResponse  = array();

        $oValParams = array(    'Id_CategoryTour'   => 'required|int',
                                'Id_tour'           => 'required|int',
                                'Date'              => 'required|string'
                            );

        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Request($Request, $oValParams, $this->oDomain);
        
        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {

            $oParam = array(    $Request->input("Id_CategoryTour"),
                                $Request->input("Id_tour"),
                                $Request->input("Date"),
                                config('var.PATH_PUBLIC') . config('var.USER_COUNTRY_THUMB')
                            );

            $oData  = DB::select('call sp_tour_availability_pax_calendar(?,?,?,?)', $oParam);


            $oResponse["Response_Status"]           = 200;
            $oResponse["Response_Code"]             = 200;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $this->oDomain." list ";
            $oResponse["Response_Data"]             = $oData;
            $oResponse["Response_Error_Message"]    = "";
            $oResponse["Response_Error_Reason"]     = "";
            
        }

        return ResponseBuilder::Response($oResponse);
    }
        
    public function Year_List(Request $Request){
        $oResponse  = array();

        $oData  = DB::select('call sp_booking_year_list()');
        
        $oResponse["Response_Status"]           = 200;
        $oResponse["Response_Code"]             = 200;
        $oResponse["Response_Domain"]           = $this->oDomain;
        $oResponse["Response_Message"]          = $this->oDomain." Index";
        $oResponse["Response_Data"]             = $oData;
        $oResponse["Response_Error_Message"]    = "";
        $oResponse["Response_Error_Reason"]     = "";

        return ResponseBuilder::Response($oResponse);
    }
}
