<?php
namespace App\Http\Controllers\Owner;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;
use Illuminate\Support\Str;

use App\Http\Helpers\ResponseBuilder;
use App\Http\Helpers\ParamsValidator;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Modules\Package\Application\PackageDaysGenerator;
use App\Modules\Package\Application\PackageTourDaysGetter;
use Illuminate\Support\Facades\DB;

class c_Package extends Controller
{
    private $oDomain;
    /** @var HistoryData */
    private $history;

    public function __construct()
    {
        $this->oDomain = "Package";
        $this->history = new HistoryData (HistoryTables::package);
    }

    public function Insert(Request $Request){
        $oResponse  = array();
        $oValParams = array(    'Package_Name'              => 'required|string|max:250',
                                'Package_Code'              => 'required|string|max:250',
                                'Package_UrlThumbnail'      => 'string|max:500',
                                'Package_Availability'      => 'required|int',
                                'Package_PaxRequired'       => 'required|int',
                                'Package_DOBRequired'       => 'required|int',
                                'Package_Status'            => 'required|int',
                                'Package_Endorser'          => 'required|int',
                                'Package_Duration'          => 'required|int',
                            );

 
        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Request($Request,$oValParams,$this->oDomain);
        
        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {           
            $oParam = array(    Str::title( $Request->input("Package_Name")),   
                                            $Request->input("Package_Code"),
                                            $Request->input('Package_UrlThumbnail'),
                                            $Request->input("Package_Availability"),
                                            $Request->input("Package_PaxRequired"),
                                            $Request->input("Package_DOBRequired"),
                                            $Request->input("Package_Status"),
                                            $Request->input("Package_Endorser"),
                                            $Request->input("Package_Duration")
                            );
            $oData = DB::select('call sp_package_insert(?,?,?,?,?,?,?,?,?)',$oParam);
            $data = null;

            //  RESPONSE
            if ($oData[0]->Response_Success == 1) {
                #region HISTORY EXEC
                $this->history->insertBasic ($Request);
                #endregion
                
                $data = [ 'Id' => $oData[0]->Response_Id ];
            } else {
                
            }
            
            $oResponse["Response_Status"]           = $oData[0]->Response_Status;
            $oResponse["Response_Code"]             = $oData[0]->Response_Code;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $oData[0]->Response_Message;
            $oResponse["Response_Data"]             = $data;
            $oResponse["Response_Error_Message"]    = $oData[0]->Response_Message;
            $oResponse["Response_Error_Reason"]     = $oData[0]->Response_Reason;
        }

        return ResponseBuilder::Response($oResponse);
    }
        
    public function Update(Request $Request){
        $oResponse  = array();
        $oValParams = array(    'Id_Package'                => 'required|int',
                                'Package_Name'              => 'required|string|max:250',
                                'Package_Code'              => 'required|string|max:250',
                                'Package_UrlThumbnail'      => 'string|max:500',
                                'Package_Availability'      => 'required|int',
                                'Package_PaxRequired'       => 'required|int',
                                'Package_DOBRequired'       => 'required|int',
                                'Package_Status'            => 'required|int',
                                'Package_Endorser'          => 'required|int',
                                'Package_Duration'          => 'required|int',
                            );


        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Request($Request,$oValParams,$this->oDomain);
        
        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
            
            #region HISTORY VARIABLES
            $this->history->obtainOld($Request->input('Id_Package'));
            #endregion

            $oParam = array(                $Request->input("Id_Package"),
                                Str::title( $Request->input("Package_Name")),   
                                            $Request->input("Package_Code"),
                                            $Request->input("Package_UrlThumbnail"),
                                            $Request->input("Package_Availability"),
                                            $Request->input("Package_PaxRequired"),
                                            $Request->input("Package_DOBRequired"),
                                            $Request->input("Package_Status"),
                                            $Request->input("Package_Endorser"),
                                            $Request->input("Package_Duration")
                            );
            $oData = DB::select('call sp_package_update(?,?,?,?,?,?,?,?,?,?)',$oParam);

            //  RESPONSE
            if ($oData[0]->Response_Success == 1) {
                #region HISTORY EXEC
                $this->history->updateBasic ( $Request->input("Id_Package"), $Request );
                #endregion
            } else {
                
            }
            
            $oResponse["Response_Status"]           = $oData[0]->Response_Status;
            $oResponse["Response_Code"]             = $oData[0]->Response_Code;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $oData[0]->Response_Message;
            $oResponse["Response_Data"]             = null;
            $oResponse["Response_Error_Message"]    = $oData[0]->Response_Message;
            $oResponse["Response_Error_Reason"]     = $oData[0]->Response_Reason;
        }

        return ResponseBuilder::Response($oResponse);

    }

    public function Delete(Request $Request, $Id){
        $oResponse  = array();
 
        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Id($Id,$this->oDomain);
        
        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
            
            #region HISTORY
            $this->history->obtainOld($Id);
            #endregion

            $oParam = array( $Id );
            $oData  = DB::select('call sp_package_delete(?)',$oParam);

            //  RESPONSE
            if ($oData[0]->Response_Success == 1) {
                #region HISTORY EXEC
                $this->history->deleteBasic ($Id, $Request);
                #endregion
            } else {
                
            }
            
            $oResponse["Response_Status"]           = $oData[0]->Response_Status;
            $oResponse["Response_Code"]             = $oData[0]->Response_Code;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $oData[0]->Response_Message;
            $oResponse["Response_Data"]             = null;
            $oResponse["Response_Error_Message"]    = $oData[0]->Response_Message;
            $oResponse["Response_Error_Reason"]     = $oData[0]->Response_Reason;
        }

        return ResponseBuilder::Response($oResponse);
    }

    public function Index(Request $Request, $Id){
        $oResponse  = array();

        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Id($Id,$this->oDomain);
        
        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {       
            $oParam = array( $Id );
            $oData  = DB::select('call sp_package_index(?)',$oParam);
            
            $oResponse["Response_Status"]           = 200;
            $oResponse["Response_Code"]             = 200;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $this->oDomain." Index";
            $oResponse["Response_Data"]             = $oData;
            $oResponse["Response_Error_Message"]    = "";
            $oResponse["Response_Error_Reason"]     = "";
        }

        return ResponseBuilder::Response($oResponse);
    }

    public function calendarDays(Request $request)
    {
        $oResponse = ParamsValidator::Validate_Request($request, [
            'Id_Package'   => 'required|int',
            'Month'     => 'required|int',
            'Year'      => 'required|int'
        ], $this->oDomain);
        if ($oResponse["Response_Code"] != 200) {
            return ResponseBuilder::Response($oResponse);
        }
        $tours = DB::select('call sp_package_tour_list(?)', [ $request->input('Id_Package') ]);
        $oData = (new PackageTourDaysGetter)->__invoke($request->input('Year'), $request->input('Month'), $tours);
        
        $oResponse["Response_Status"]           = 200;
        $oResponse["Response_Code"]             = 200;
        $oResponse["Response_Domain"]           = $this->oDomain;
        $oResponse["Response_Message"]          = $this->oDomain." Index ";
        $oResponse["Response_Data"]             = $oData;
        $oResponse["Response_Error_Message"]    = "";
        $oResponse["Response_Error_Reason"]     = "";
        return ResponseBuilder::Response($oResponse);
    }

    public function List(Request $Request, $Id)
    {
        $oResponse  = array();

        $oResponse = ParamsValidator::Validate_Action($Id, $this->oDomain);

        if ($oResponse["Response_Code"] == 200) {
            $oParam = array( $Id );
            $oData  = DB::select('call sp_package_list(?)', $oParam);

            $oResponse["Response_Status"]           = 200;
            $oResponse["Response_Code"]             = 200;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $this->oDomain." list ".$Id;
            $oResponse["Response_Data"]             = $oData;
            $oResponse["Response_Error_Message"]    = "";
            $oResponse["Response_Error_Reason"]     = "";
        }

        return ResponseBuilder::Response($oResponse);
    }

    public function Search(Request $Request)
    {
        $oResponse  = array();
        $oValParams = array( 'Id_Booking'   => 'required|int' );
 
        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Request($Request,$oValParams,$this->oDomain);

        if ($oResponse["Response_Code"] == 200) {
            //$oParam   = array( $Request->input("Id_Booking") );
            //$oData    = DB::select('call sp_package_search(?)',$oParam);
            $oParam     = array( 'active' );
            $oData      = DB::select('call sp_package_list(?)',$oParam);

            $Response_Data  = array();

            for($k = 0; $k < count($oData); $k++){

                $oParam         = array( $oData[$k]->Id_Package );
                $oData_Tour     = DB::select('call sp_package_tour_list(?)',$oParam);
                $oPackageRate   = DB::select('call sp_package_rate_list(?, ?)', ['all', $oData[$k]->Id_Package]);

                array_push($Response_Data, array(
                    "Id_Package"            => $oData[$k]->Id_Package,
                    "Package_Name"          => $oData[$k]->Package_Name,
                    "Package_Code"          => $oData[$k]->Package_Code,
                    "Package_Duration"      => $oData[$k]->Package_Duration,
                    "Package_Availability"  => $oData[$k]->Package_Availability,
                    "Package_Status"        => $oData[$k]->Package_Status,
                    "Package_Tour"          => $oData_Tour,
                    'Package_Rate'          => $oPackageRate
                ));

            }

            $oResponse["Response_Status"]           = 200;
            $oResponse["Response_Code"]             = 200;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $this->oDomain." search";
            $oResponse["Response_Data"]             = $Response_Data;
            $oResponse["Response_Error_Message"]    = "";
            $oResponse["Response_Error_Reason"]     = "";
        }

        return ResponseBuilder::Response($oResponse);
    }
        
    public function Selector(Request $Request,$Id){
        if( is_numeric($Id) ){
            return SELF::Index( $Request,$Id );
        }else if( $Id == "search" ){
            return SELF::Search( $Request );
        }else{
            return SELF::List( $Request,$Id );
        }
    }

    public function IndexBooking(Request $Request){
        $oResponse  = array();
        $oValParams     = array(    'Id_Package'            => 'required|string|max:20',
                                    'Id_Language'           => 'required|string|max:2'
                                );

        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Request($Request,$oValParams,$this->oDomain);
        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
            $oParam     = array(    $Request->input("Id_Package"),
                                    $Request->input("Id_Language")
                                );
            $oData  = DB::select('call sp_package_booking_index(?,?)',$oParam);

            
            if(isset($oData[0]->Id_Package)){
                
                $oParam     = array(    $oData[0]->Id_Package,
                                        $oData[0]->Id_Language
                                    );

                $oDataRate  = DB::select('call sp_package_rate_booking(?,?)',$oParam);

                $oParam     = array(    $oData[0]->Id_Package,
                                        $oData[0]->Id_Language
                                    );
                $oDataTour  = DB::select('call sp_tour_booking(?,?)',$oParam); 

                if(isset($oDataTour[0]->Id_Tour)){
                    for($j = 0; $j < count($oDataTour); $j++){
                        $oParam     = array(    $oDataTour[$j]->Id_Tour,
                                                $oData[0]->Id_Language
                                            );
    
                        $oDataTypeUpgrade  = DB::select('call sp_tour_upgrade_type_booking(?,?)',$oParam);
                       
                        if(isset($oDataTypeUpgrade[0]->Id_TourUpgradeType)){
                            
                            for($k = 0; $k < count($oDataTypeUpgrade); $k++){
                                $oParam     = array(    $oDataTypeUpgrade[$k]->Id_TourUpgradeType,
                                                        $oData[0]->Id_Language
                                                    );
    
                                $oDataUpgrade  = DB::select('call sp_tour_upgrade_booking(?,?)',$oParam);
                                $oDataTypeUpgrade[$k]->Upgrade           =$oDataUpgrade;
                                
                            }
                            
                        }
    
    
                        $oParam     = array(    $oDataTour[$j]->Id_Tour,
                                                $oData[0]->Id_Language
                                            );
    
                        $oDataTypeEquipment  = DB::select('call sp_tour_equipment_type_booking(?,?)',$oParam);
    
                        if(isset($oDataTypeEquipment[0]->Id_TourEquipmentType)){
                            for($k = 0; $k < count($oDataTypeEquipment); $k++){
                                $oParam     = array(    $oDataTypeEquipment[$k]->Id_TourEquipmentType,
                                                        $oData[0]->Id_Language
                                                    );
    
                                $oDataEquipment  = DB::select('call sp_tour_equipment_booking(?,?)',$oParam);
                                $oDataTypeEquipment[$k]->Equipment           =$oDataEquipment;
                                
                                if(isset($oDataEquipment[0]->Id_Equipment)){
                                    for($l = 0; $l < count($oDataEquipment); $l++){
                                        $oParam     = array($oDataEquipment[$l]->Id_Equipment,
                                                            $oDataTour[0]->Tour_Duration); 
                                        
                                        $oDataEquipmentRate  = DB::select('call sp_equipment_rate_select(?,?)',$oParam);

                                        $oDataEquipment[$l]->Rate               =$oDataEquipmentRate;
                                    }
                                }
                            }
    
                        } 
    
                        $oParam     = array(    $oDataTour[$j]->Id_Tour,
                                                $oData[0]->Id_Language
                                            );
    
                        $oDataTypeExtra  = DB::select('call sp_tour_extra_type_booking(?,?)',$oParam);
    
                        if(isset($oDataTypeExtra[0]->Id_TourExtraType)){
                            for($k = 0; $k < count($oDataTypeExtra); $k++){
                                $oParam     = array(    $oDataTypeExtra[$k]->Id_TourExtraType,
                                                        $oData[0]->Id_Language
                                                    );
    
                                $oDataExtra  = DB::select('call sp_tour_extra_booking(?,?)',$oParam);
                                $oDataTypeExtra[$k]->Extra           =$oDataExtra;
                            }
    
                        }
        
                        $Path_Thumb     = config("var.PATH_PUBLIC").config("var.USER_COUNTRY_THUMB");   
                        $oParam = array( $Path_Thumb);
         
                        $oDataCountry  = DB::select('call sp_client_user_country_list(?)',$oParam);
                        
                        $oParam     = array(    $oData[0]->Id_Language );
        
                        $oDataDoc  = DB::select('call sp_client_type_document_list(?)',$oParam);

                        $oParam     = array(    $oDataTour[$j]->Id_Tour);
    
                        $oDataLock  = DB::select('call sp_tour_lock_list_all(?)',$oParam);
    
                        $oDataTour[$j]->Type_Upgrade                = $oDataTypeUpgrade;
                        $oDataTour[$j]->Type_Equipment              = $oDataTypeEquipment;
                        $oDataTour[$j]->Type_Extra                  = $oDataTypeExtra;
                        $oData[0]->Type_Document                    = $oDataDoc;
                        $oData[0]->Country                          = $oDataCountry;
                        $oDataTour[$j]->Lock                        = $oDataLock;
                    }
                        
                }
                

                $oData[0]->Tours                         = $oDataTour;
                $oData[0]->Rate                            = $oDataRate;
            }

            

            $oResponse["Response_Status"]           = 200;
            $oResponse["Response_Code"]             = 200;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $this->oDomain." Index ";
            $oResponse["Response_Data"]             = $oData;
            $oResponse["Response_Error_Message"]    = "";
            $oResponse["Response_Error_Reason"]     = "";
        }

        return ResponseBuilder::Response($oResponse);
    }
        
        
}