<?php
namespace App\Http\Controllers\Owner;

use App\Http\Controllers\Controller;

use DB;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

use App\Http\Helpers\ResponseBuilder;
use App\Http\Helpers\ParamsValidator;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use Intervention\Image\ImageManagerStatic as Image;

class c_Package_Fee extends Controller
{
	private $oDomain;
	/** @var HistoryData */
	private $history;
	/** @var HistoryData */
	private $historyPackage;

	public function __construct()
	{
		$this->oDomain = "Package Fee";
		$this->history = new HistoryData (HistoryTables::package_fee);
		$this->historyPackage = new HistoryData (HistoryTables::package);
	}

	public function Insert_All(Request $Request){
		$oResponse = array();
		$oValParams = array(    'PackageFee_Value'   	=> 'required|string',
								'PackageFee_Delete'		=> 'string',
								'PackageFee_Type'		=> 'required|int',
								'Id_Package'			=> 'required|int'
							);

		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Request($Request,$oValParams,$this->oDomain);


		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {

			$oldValue = DB::select ('call sp_package_fee_list(?)', [ $Request->input('Id_Package')]);

			$PackageFee_Value 	= json_decode($Request->input("PackageFee_Value"));
			$PackageFee_Delete 	= json_decode($Request->input("PackageFee_Delete"));

			for($k = 0; $k < count($PackageFee_Value); $k++){

				if( $PackageFee_Value[$k]->Id_PackageFee == 0){
					$oParam = array(    $PackageFee_Value[$k]->PackageFee_Amount,
										$PackageFee_Value[$k]->PackageFee_Full,
										$Request->input("PackageFee_Type"),
										$Request->input("Id_Package"),
									);
					$oData = DB::select('call sp_package_fee_insert(?,?,?,?)',$oParam);

					if($oData[0]->Response_Success == 0){
						break;
					}
				}else{
					$oParam = array(    $PackageFee_Value[$k]->Id_PackageFee,
										$PackageFee_Value[$k]->PackageFee_Amount,
										$PackageFee_Value[$k]->PackageFee_Full,
										$Request->input("PackageFee_Type"),
										$Request->input("Id_Package")
									);
					$oData = DB::select('call sp_package_fee_update(?,?,?,?,?)',$oParam);

					if($oData[0]->Response_Success == 0){
						break;
					}
				}

			}

			if(is_array($PackageFee_Delete) == true){
				for($k = 0; $k < count($PackageFee_Delete); $k++){
					$oParam = array(    $PackageFee_Delete[$k]->Id_PackageFee );
					$oData = DB::select('call sp_package_fee_delete(?)',$oParam);
	
					if($oData[0]->Response_Success == 0){
						break;
					}
				}	
			}

			if ($oData[0]->Response_Success == 1) {
				$newValue = DB::select ('call sp_package_fee_list(?)', [ $Request->input('Id_Package')]);
				$this->historyPackage->update (
					$Request->input("Id_Package"),
					$oldValue,
					$newValue,
					$Request,
					false
				);
			}
			

			$oResponse["Response_Status"]			= $oData[0]->Response_Status;
			$oResponse["Response_Code"]				= $oData[0]->Response_Code;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $oData[0]->Response_Message;
			$oResponse["Response_Data"]				= null;
			$oResponse["Response_Error_Message"]	= $oData[0]->Response_Message;
			$oResponse["Response_Error_Reason"]		= $oData[0]->Response_Reason;
		}
		
		return ResponseBuilder::Response($oResponse);

	}
	public function Insert(Request $Request){
		$oResponse  = array();
		$oValParams = array(    'PackageFee_Amount'		=> 'required|int',
								'PackageFee_Full'		=> 'required|int',
								'PackageFee_Type'		=> 'required|int',
								'Id_Package'			=> 'required|int'
							);


		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Request($Request,$oValParams,$this->oDomain);
		
		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {
			$oParam = array(    $Request->input("PackageFee_Amount"),
								$Request->input("PackageFee_Full"),
								$Request->input("PackageFee_Type"),
								$Request->input("Id_Package"),
							);
			$oData = DB::select('call sp_package_fee_insert(?,?,?,?)',$oParam);

			//  RESPONSE
			if ($oData[0]->Response_Success == 1) {
				#region HISTORY EXEC
				$this->history->insertBasic ($Request);
				#endregion
			} else {
				
			}
			
			$oResponse["Response_Status"]			= $oData[0]->Response_Status;
			$oResponse["Response_Code"]				= $oData[0]->Response_Code;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $oData[0]->Response_Message;
			$oResponse["Response_Data"]				= null;
			$oResponse["Response_Error_Message"]	= $oData[0]->Response_Message;
			$oResponse["Response_Error_Reason"]		= $oData[0]->Response_Reason;
		}

		return ResponseBuilder::Response($oResponse);
		
	}
	public function Update(Request $Request){
		$oResponse  = array();
		$oValParams = array(	'Id_PackageFee'			=> 'required|int',
								'PackageFee_Amount'		=> 'required|int',
								'PackageFee_Full'		=> 'required|int',
								'PackageFee_Type'		=> 'required|int',
								'Id_Package'			=> 'required|int'
							);


		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Request($Request,$oValParams,$this->oDomain);
		
		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {
			
			#region HISTORY VARIABLES
			$this->history->obtainOld($Request->input('Id_PackageFee'));
			#endregion

			$oParam = array(    $Request->input("Id_PackageFee"),
								$Request->input("PackageFee_Amount"),
								$Request->input("PackageFee_Full"),
								$Request->input("PackageFee_Type"),
								$Request->input("Id_Package")
							);
			$oData = DB::select('call sp_package_fee_update(?,?,?,?,?)',$oParam);

			//  RESPONSE
			if ($oData[0]->Response_Success == 1) {
				#region HISTORY EXEC
				$this->history->updateBasic ( $Request->input("Id_PackageFee"), $Request );
				#endregion
			} else {
				
			}
			
			$oResponse["Response_Status"]			= $oData[0]->Response_Status;
			$oResponse["Response_Code"]				= $oData[0]->Response_Code;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $oData[0]->Response_Message;
			$oResponse["Response_Data"]				= null;
			$oResponse["Response_Error_Message"]	= $oData[0]->Response_Message;
			$oResponse["Response_Error_Reason"]		= $oData[0]->Response_Reason;
		}

		return ResponseBuilder::Response($oResponse);

	}
	public function Delete(Request $Request, $Id){
		$oResponse  = array();

		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Id($Id,$this->oDomain);
		
		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {
			
			#region HISTORY
			$this->history->obtainOld($Id);
			#endregion

			$oParam = array( $Id );
			$oData 	= DB::select('call sp_package_fee_delete(?)',$oParam);

			//  RESPONSE
			if ($oData[0]->Response_Success == 1) {
				#region HISTORY EXEC
				$this->history->deleteBasic ($Id, $Request);
				#endregion
			} else {
				
			}
			
			$oResponse["Response_Status"]			= $oData[0]->Response_Status;
			$oResponse["Response_Code"]				= $oData[0]->Response_Code;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $oData[0]->Response_Message;
			$oResponse["Response_Data"]				= null;
			$oResponse["Response_Error_Message"]	= $oData[0]->Response_Message;
			$oResponse["Response_Error_Reason"]		= $oData[0]->Response_Reason;
		}

		return ResponseBuilder::Response($oResponse);
	}
	public function Index(Request $Request, $Id){
		$oResponse  = array();

		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Id($Id,$this->oDomain);
		
		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {		
			$oParam = array( $Id );
			$oData 	= DB::select('call sp_package_fee_index(?)',$oParam);
			
			$oResponse["Response_Status"]			= 200;
			$oResponse["Response_Code"]				= 200;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $this->oDomain." ndex";
			$oResponse["Response_Data"]				= $oData;
			$oResponse["Response_Error_Message"]	= "";
			$oResponse["Response_Error_Reason"]		= "";
		}

		return ResponseBuilder::Response($oResponse);
	}
	public function List(Request $Request, $Id_Package){
		$oResponse  = array();

		$oResponse = ParamsValidator::Validate_Id($Id_Package,$this->oDomain);

		if ($oResponse["Response_Code"] == 200) {
			$oParam = array( $Id_Package );
			$oData  = DB::select('call sp_package_fee_list(?)',$oParam);

			$oResponse["Response_Status"]			= 200;
			$oResponse["Response_Code"]				= 200;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $this->oDomain." list";
			$oResponse["Response_Data"]				= $oData;
			$oResponse["Response_Error_Message"]	= "";
			$oResponse["Response_Error_Reason"]		= "";
		}

		return ResponseBuilder::Response($oResponse);
	}

	
}