<?php
namespace App\Http\Controllers\Owner;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Http\Helpers\ResponseBuilder;
use App\Http\Helpers\ParamsValidator;
use Illuminate\Support\Facades\DB;

class c_Schedule extends Controller
{
    private $oDomain;

    public function __construct()
    {
        $this->oDomain = "Schedule";
    }

    public function Insert(Request $Request)
    {
        
        $oValParams = [
            'Schedule_DateExpire'   => 'required|string|date',
            'Schedule_Description'  => 'required|string|max:250',
            'Id_Booking'            => 'required|int',
            'Id_Admin'              => 'required|int',
            'Schedule_Detail'       => 'required|string'
        ];

        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Request($Request, $oValParams, $this->oDomain);
        
        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
            $admin = DB::select('call sp_admin_session_get(?,?)', [
                $Request->header('Token'),
                ''
            ])[0];

            $oParam = [
                $Request->input('Schedule_DateExpire'),
                $Request->input("Schedule_Description"),
                1,
                $Request->input("Id_Booking"),
                $admin->Response_Id_Admin
            ];
            

            $oScheduleResult = DB::select('call sp_schedule_insert(?,?,?,?,?)', $oParam);
            $oData = $oScheduleResult;
            if ($oScheduleResult[0]->Response_Code == 200) {
                $scheduleDetail  = json_decode($Request->Schedule_Detail);

                foreach ($scheduleDetail as $detail) {
                    $oParam = [
                        $oScheduleResult[0]->Response_Id,
                        $detail->Id_Invoice,
                        $detail->ScheduleDetail_Total,
                    ];
                    $oData = DB::select('call sp_schedule_detail_insert(?,?,?)', $oParam);
                }
            }
            
            $oResponse["Response_Status"]           = $oData[0]->Response_Status;
            $oResponse["Response_Code"]             = $oData[0]->Response_Code;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $oData[0]->Response_Message;
            $oResponse["Response_Data"]             = null;
            $oResponse["Response_Error_Message"]    = $oData[0]->Response_Message;
            $oResponse["Response_Error_Reason"]     = $oData[0]->Response_Reason;
        }

        return ResponseBuilder::Response($oResponse);
        
    }
    public function Update(Request $Request)
    {
        $oResponse  = array();
        $oValParams = [
            'Id_Schedule'           => 'required|int',
            'Schedule_DateExpire'   => 'required|string|date',
            'Schedule_DatePayment'  => 'required|string|date',
            'Schedule_Description'  => 'required|string'
        ];


        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Request($Request, $oValParams, $this->oDomain);
        
        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
            $oParam = [
                $Request->input("Id_Schedule"),
                $Request->input("Schedule_DateExpire"),
                $Request->input("Schedule_DatePayment"),
                $Request->input("Schedule_Description")
            ];
            $oData = DB::select('call sp_schedule_update(?,?,?,?)', $oParam);
            
            $oResponse["Response_Status"]           = $oData[0]->Response_Status;
            $oResponse["Response_Code"]             = $oData[0]->Response_Code;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $oData[0]->Response_Message;
            $oResponse["Response_Data"]             = null;
            $oResponse["Response_Error_Message"]    = $oData[0]->Response_Message;
            $oResponse["Response_Error_Reason"]     = $oData[0]->Response_Reason;
        }

        return ResponseBuilder::Response($oResponse);

    }
    public function Delete(Request $Request, $Id){
        $oResponse  = array();

        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Id ($Id, $this->oDomain);
        
        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
            $oParam = array( $Id );
            $oData  = DB::select('call sp_schedule_delete(?)', $oParam);
            
            $oResponse["Response_Status"]           = $oData[0]->Response_Status;
            $oResponse["Response_Code"]             = $oData[0]->Response_Code;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $oData[0]->Response_Message;
            $oResponse["Response_Data"]             = null;
            $oResponse["Response_Error_Message"]    = $oData[0]->Response_Message;
            $oResponse["Response_Error_Reason"]     = $oData[0]->Response_Reason;
        }

        return ResponseBuilder::Response($oResponse);
    }
    public function Index(Request $Request, $Id){
        $oResponse  = array();

        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Id ($Id, $this->oDomain);
        
        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
            $oParam = array( $Id );
            $oData  = DB::select('call sp_schedule_index(?)',$oParam);
            
            $oResponse["Response_Status"]           = 200;
            $oResponse["Response_Code"]             = 200;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $this->oDomain." Index";
            $oResponse["Response_Data"]             = $oData;
            $oResponse["Response_Error_Message"]    = "";
            $oResponse["Response_Error_Reason"]     = "";
        }

        return ResponseBuilder::Response($oResponse);
    }

    public function Search (Request $Request, $Schedule_Token){
        $oResponse  = array();

        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Token ($Schedule_Token, $this->oDomain);
        
        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
            $oParam = [ $Schedule_Token ];
            $oData  = DB::select('call sp_schedule_search (?)',$oParam);
            
            $oResponse["Response_Status"]           = 200;
            $oResponse["Response_Code"]             = 200;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $this->oDomain." Index";
            $oResponse["Response_Data"]             = $oData;
            $oResponse["Response_Error_Message"]    = "";
            $oResponse["Response_Error_Reason"]     = "";
        }

        return ResponseBuilder::Response($oResponse);
    }

    public function List (Request $Request, $Id_Booking) {
        $oResponse  = array();

        $oResponse = ParamsValidator::Validate_Id ($Id_Booking, $this->oDomain);

        if ($oResponse["Response_Code"] == 200) {
            $oData  = DB::select('call sp_schedule_list(?)', [ $Id_Booking ]);

            $oResponse["Response_Status"]           = 200;
            $oResponse["Response_Code"]             = 200;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $this->oDomain." list ".$Id_Booking;
            $oResponse["Response_Data"]             = $oData;
            $oResponse["Response_Error_Message"]    = "";
            $oResponse["Response_Error_Reason"]     = "";
        }

        return ResponseBuilder::Response($oResponse);
    }
}
