<?php
namespace App\Http\Controllers\Owner;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;
use Illuminate\Support\Str;

use App\Http\Helpers\ResponseBuilder;
use App\Http\Helpers\ParamsValidator;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use Illuminate\Support\Facades\DB;

class c_Upgrade extends Controller
{
    private $oDomain;
    /** @var HistoryData */
    private $history;

    public function __construct()
    {
        $this->oDomain = "Upgrade";
        $this->history = new HistoryData(HistoryTables::upgrade);
    }

    public function Insert(Request $Request)
    {
        $oResponse  = array();
        $oValParams = array(    'Upgrade_Code'                  => 'required|string|max:11',
                                'Upgrade_Name'                  => 'required|string|max:250',
                                'Upgrade_Feature'               => 'required|string',
                                'Upgrade_Price'                 => 'required|numeric',
                                'Upgrade_PriceConfidential'     => 'required|numeric',
                                'Upgrade_OneWay'                => 'required|int',
                                'Upgrade_Status'                => 'required|int',
                                'Id_TypeUpgrade'                => 'required|int'
                            );


        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Request($Request, $oValParams, $this->oDomain);
        
        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
            $oParam = array(                $Request->input("Upgrade_Code"),
                                 Str::title($Request->input("Upgrade_Name")),
                                            $Request->input("Upgrade_Feature"),
                                            $Request->input("Upgrade_Price"),
                                            $Request->input("Upgrade_PriceConfidential"),
                                            $Request->input("Upgrade_OneWay"),
                                            $Request->input("Upgrade_Status"),
                                            $Request->input("Id_TypeUpgrade")
                            );
            $oData = DB::select('call sp_upgrade_insert(?,?,?,?,?,?,?,?)', $oParam);

            //  RESPONSE
            if ($oData[0]->Response_Success == 1) {
                #region HISTORY EXEC
                $this->history->insertBasic($Request);
                #endregion
            } else {
            }
            
            $oResponse["Response_Status"]           = $oData[0]->Response_Status;
            $oResponse["Response_Code"]             = $oData[0]->Response_Code;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $oData[0]->Response_Message;
            $oResponse["Response_Data"]             = null;
            $oResponse["Response_Error_Message"]    = $oData[0]->Response_Message;
            $oResponse["Response_Error_Reason"]     = $oData[0]->Response_Reason;
        }

        return ResponseBuilder::Response($oResponse);
    }

    public function Update(Request $Request)
    {
        $oResponse  = array();
        $oValParams = array(    'Id_Upgrade'                    => 'required|int',
                                'Upgrade_Code'                  => 'required|string|max:10',
                                'Upgrade_Name'                  => 'required|string|max:250',
                                'Upgrade_Feature'               => 'required|string',
                                'Upgrade_Price'                 => 'required|numeric',
                                'Upgrade_PriceConfidential'     => 'required|numeric',
                                'Upgrade_OneWay'                => 'required|int',
                                'Upgrade_Status'                => 'required|int',
                                'Id_TypeUpgrade'                => 'required|int'
                            );


        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Request($Request, $oValParams, $this->oDomain);
        
        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
            #region HISTORY VARIABLES
            $this->history->obtainOld($Request->input('Id_Upgrade'));
            #endregion

            $oParam = array(                $Request->input("Id_Upgrade"),
                                            $Request->input("Upgrade_Code"),
                                 Str::title($Request->input("Upgrade_Name")),
                                            $Request->input("Upgrade_Feature"),
                                            $Request->input("Upgrade_Price"),
                                            $Request->input("Upgrade_PriceConfidential"),
                                            $Request->input("Upgrade_OneWay"),
                                            $Request->input("Upgrade_Status"),
                                            $Request->input("Id_TypeUpgrade")
                            );
            $oData = DB::select('call sp_upgrade_update(?,?,?,?,?,?,?,?,?)', $oParam);

            //  RESPONSE
            if ($oData[0]->Response_Success == 1) {
                #region HISTORY EXEC
                $this->history->updateBasic($Request->input("Id_Upgrade"), $Request);
                #endregion
            } else {
            }
            
            $oResponse["Response_Status"]           = $oData[0]->Response_Status;
            $oResponse["Response_Code"]             = $oData[0]->Response_Code;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $oData[0]->Response_Message;
            $oResponse["Response_Data"]             = null;
            $oResponse["Response_Error_Message"]    = $oData[0]->Response_Message;
            $oResponse["Response_Error_Reason"]     = $oData[0]->Response_Reason;
        }

        return ResponseBuilder::Response($oResponse);
    }

    public function Delete(Request $Request, $Id) {
        $oResponse  = array();

        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Id($Id, $this->oDomain);
        
        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
            #region HISTORY
            $this->history->obtainOld($Id);
            #endregion

            $oParam = array( $Id );
            $oData  = DB::select('call sp_upgrade_delete(?)', $oParam);

            //  RESPONSE
            if ($oData[0]->Response_Success == 1) {
                #region HISTORY EXEC
                $this->history->deleteBasic($Id, $Request);
                #endregion
            } else {
            }
            
            $oResponse["Response_Status"]           = $oData[0]->Response_Status;
            $oResponse["Response_Code"]             = $oData[0]->Response_Code;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $oData[0]->Response_Message;
            $oResponse["Response_Data"]             = null;
            $oResponse["Response_Error_Message"]    = $oData[0]->Response_Message;
            $oResponse["Response_Error_Reason"]     = $oData[0]->Response_Reason;
        }

        return ResponseBuilder::Response($oResponse);
    }
    public function Index(Request $Request, $Id)
    {
        $oResponse  = array();

        // VALIDANDO DATOS
        $oResponse = ParamsValidator::Validate_Id($Id, $this->oDomain);
        
        //  INGRESANDO DATOS
        if ($oResponse["Response_Code"] == 200) {
            $oParam = array( $Id );
            $oData  = DB::select('call sp_upgrade_index(?)', $oParam);
            
            $oResponse["Response_Status"]           = 200;
            $oResponse["Response_Code"]             = 200;
            $oResponse["Response_Domain"]           = $this->oDomain;
            $oResponse["Response_Message"]          = $this->oDomain." Index";
            $oResponse["Response_Data"]             = $oData;
            $oResponse["Response_Error_Message"]    = "";
            $oResponse["Response_Error_Reason"]     = "";
        }

        return ResponseBuilder::Response($oResponse);
    }
    public function List (Request $Request, $Id)
    {
        $oResponse  = array();
        $oValParams = array(  'Id_TypeUpgrade'  => 'required|int');


        $oResponse = ParamsValidator::Validate_Action($Id, $this->oDomain);

        if ($oResponse["Response_Code"] == 200) {

            $oResponse = ParamsValidator::Validate_Request($Request, $oValParams, $this->oDomain);

            if ($oResponse["Response_Code"] == 200) {
                $oParam =   [
                    $Id ,
                    $Request->input("Id_TypeUpgrade")
                ];
                $oData  = DB::select('call sp_upgrade_list(?,?)', $oParam);
        
                $oResponse["Response_Status"]           = 200;
                $oResponse["Response_Code"]             = 200;
                $oResponse["Response_Domain"]           = $this->oDomain;
                $oResponse["Response_Message"]          = $this->oDomain." list ".$Id;
                $oResponse["Response_Data"]             = $oData;
                $oResponse["Response_Error_Message"]    = "";
                $oResponse["Response_Error_Reason"]     = "";
            }
        }

        return ResponseBuilder::Response($oResponse);
    }
        
    public function Selector(Request $Request, $Id)
    {
        if (is_numeric($Id)) {
            return $this->Index($Request, $Id);
        } else {
            return $this->List($Request, $Id);
        }
    }
        
        
}