<?php
namespace App\Http\Controllers\Owner;

use App\Http\Controllers\Controller;

use DB;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

use App\Http\Helpers\ResponseBuilder;
use App\Http\Helpers\ParamsValidator;
use Intervention\Image\ImageManagerStatic as Image;


use App\Mail\c_Mail_User;
use Illuminate\Support\Facades\Mail;
use App\Http\Controllers\Mail\c_Mail_Term;
use App\Http\History\HistoryData;
use App\Http\History\HistoryTables;
use App\Providers\BookingMailSender;

class c_User extends Controller
{
	private $oDomain;
	/** @var HistoryData */
	private $history;

	public function __construct()
	{
		$this->oDomain = "User";
		$this->history = new HistoryData (HistoryTables::user);
	}

	public function Insert(Request $Request){
        $Password  = array();
		$oResponse  = array();
		$oValParams = array(    'User_Name'             => 'required|string|max:100',
                                'User_LastName'         => 'required|string|max:100',
                                'User_Email'            => 'required|string|max:250',
                                'User_PhoneCode'        => 'string',
								'User_Phone'		    => 'string|max:20',
								'User_NoDocument'		=> 'string',
								'User_Address'		    => 'string',
								'User_ContactName'		=> 'string',
								'User_ContactPhone'		=> 'string',
								'User_Type'				=> 'required|int',
								'User_Status'           => 'required|int',
								'Id_TypeDocument'		=> 'int',
                                'Id_UserCountry'        => 'required|int'
							);


		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Request($Request,$oValParams,$this->oDomain);

		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {
			$oParam = array(    Str::title( $Request->input("User_Name")),
								Str::title( $Request->input("User_LastName")),
                                            $Request->input("User_Email"),
                                            $Request->input("User_PhoneCode"),
											$Request->input("User_Phone"),
								Str::upper( $Request->input("User_NoDocument")),
								Str::title( $Request->input("User_Address")),
								Str::title( $Request->input("User_ContactName")),
                                            $Request->input("User_ContactPhone"),
											$Request->input("User_Type"),
											$Request->input("User_Status"),
                                            $Request->input("Id_TypeDocument"),
                                            $Request->input("Id_UserCountry")
							);
			$oData = DB::select('call sp_user_insert(?,?,?,?,?,?,?,?,?,?,?,?,?)',$oParam);
			$Password[0] = null;
			$Id_User = NULL;

			//  RESPONSE
			if($oData[0]->Response_Success == 1){
				try {
					$Id_User 				= $oData[0]->Response_Id;

					$Variables	= array( 	"Lang" 			=> 1,
											"User"			=> $Request->input("User_Email"),
											"Password" 		=> $oData[0]->Response_Password,
											'WebUrl'		=> BookingMailSender::getClientWebUrl()[0]->Credential_Value,
											'ResourcesUrl'	=> BookingMailSender::getResourcesUrl()[0]->Credential_Value
										);

					$oMail_User             = new c_Mail_User;
					$oMail_User->Type 		= 1;
					$oMail_User->Subject 	= "Your Account Password";
					$oMail_User->Content 	= $Variables;

					if (config('var.SEND_AUTO_ACCESSDATA')) {
						Mail::to($Request->input("User_Email"))->send($oMail_User);
					} else {
						Mail::to(config('var.SEND_EMAIL_ACCESSDATA'))->send($oMail_User);
					}
				} catch (\Throwable $t) {}

				#region HISTORY EXEC
				$this->history->insertBasic ($Request);
				#endregion

			}else{

			}

			$oResponse["Response_Status"]			= $oData[0]->Response_Status;
			$oResponse["Response_Code"]				= $oData[0]->Response_Code;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $oData[0]->Response_Message;
			$oResponse["Response_Data"]				= [ 'Id' => $Id_User ];
			$oResponse["Response_Error_Message"]	= $oData[0]->Response_Message;
			$oResponse["Response_Error_Reason"]		= $oData[0]->Response_Reason;
		}

		return ResponseBuilder::Response($oResponse);

	}

	public function Update(Request $Request){
		$oResponse  = array();
		$oValParams = array(    'Id_User'      	        => 'required|int',
								'User_Name'             => 'required|string|max:100',
                                'User_LastName'         => 'required|string|max:100',
                                'User_Email'            => 'required|string|max:250',
                                'User_PhoneCode'        => 'string',
								'User_Phone'		    => 'string',
								'User_NoDocument'		=> 'string',
								'User_Address'		    => 'string',
								'User_ContactName'		=> 'string',
								'User_ContactPhone'		=> 'string',
								'User_Type'				=> 'required|int',
								'User_Status'           => 'required|int',
								'Id_TypeDocument'		=> 'int',
                                'Id_UserCountry'        => 'required|int'
							);


		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Request($Request,$oValParams,$this->oDomain);

		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {

			#region HISTORY VARIABLES
			$this->history->obtainOld($Request->input('Id_User'));
			#endregion

			$oParam = array(    			$Request->input("Id_User"),
								Str::title( $Request->input("User_Name")),
								Str::title( $Request->input("User_LastName")),
											$Request->input("User_Email"),
											$Request->input("User_PhoneCode"),
											$Request->input("User_Phone"),
								Str::upper( $Request->input("User_NoDocument")),
								Str::title( $Request->input("User_Address")),
								Str::title( $Request->input("User_ContactName")),
                                            $Request->input("User_ContactPhone"),
											$Request->input("User_Type"),
											$Request->input("User_Status"),
											$Request->input("Id_TypeDocument"),
											$Request->input("Id_UserCountry")
							);
			$oData = DB::select('call sp_user_update(?,?,?,?,?,?,?,?,?,?,?,?,?,?)',$oParam);

			//  RESPONSE
			if ($oData[0]->Response_Success == 1) {
				#region HISTORY EXEC
				$this->history->updateBasic ( $Request->input("Id_User"), $Request );
				#endregion
			} else {

			}

			$oResponse["Response_Status"]			= $oData[0]->Response_Status;
			$oResponse["Response_Code"]				= $oData[0]->Response_Code;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $oData[0]->Response_Message;
			$oResponse["Response_Data"]				= null;
			$oResponse["Response_Error_Message"]	= $oData[0]->Response_Message;
			$oResponse["Response_Error_Reason"]		= $oData[0]->Response_Reason;
		}

		return ResponseBuilder::Response($oResponse);

	}

	public function Delete(Request $Request, $Id){
		$oResponse  = array();

		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Id($Id,$this->oDomain);

		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {

			#region HISTORY
			$this->history->obtainOld($Id);
			#endregion

			$oParam = array( $Id );
			$oData 	= DB::select('call sp_user_delete(?)',$oParam);

			//  RESPONSE
			if ($oData[0]->Response_Success == 1) {
				#region HISTORY EXEC
				$this->history->deleteBasic ($Id, $Request);
				#endregion
			} else { }

			$oResponse["Response_Status"]			= $oData[0]->Response_Status;
			$oResponse["Response_Code"]				= $oData[0]->Response_Code;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $oData[0]->Response_Message;
			$oResponse["Response_Data"]				= null;
			$oResponse["Response_Error_Message"]	= $oData[0]->Response_Message;
			$oResponse["Response_Error_Reason"]		= $oData[0]->Response_Reason;
		}

		return ResponseBuilder::Response($oResponse);
	}

	public function Index(Request $Request, $Id){
		$oResponse  = array();

		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Id($Id,$this->oDomain);

		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {
			$oParam = array( $Id );
			$oData 	= DB::select('call sp_user_index(?)',$oParam);

			$oResponse["Response_Status"]			= 200;
			$oResponse["Response_Code"]				= 200;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $this->oDomain." Index";
			$oResponse["Response_Data"]				= $oData;
			$oResponse["Response_Error_Message"]	= "";
			$oResponse["Response_Error_Reason"]		= "";
		}

		return ResponseBuilder::Response($oResponse);
	}

	public function List(Request $Request, $Id,$Type){
		$oResponse  = array();

		$oResponse = ParamsValidator::Validate_Action($Id,$this->oDomain);

		if ($oResponse["Response_Code"] == 200) {

			$oResponse = ParamsValidator::Validate_Id($Type,$this->oDomain);

			if ($oResponse["Response_Code"] == 200) {

				$oParam = array( $Id,$Type );
				$oData  = DB::select('call sp_user_list(?,?)',$oParam);

				$oResponse["Response_Status"]			= 200;
				$oResponse["Response_Code"]				= 200;
				$oResponse["Response_Domain"]			= $this->oDomain;
				$oResponse["Response_Message"]			= $this->oDomain." list ".$Id;
				$oResponse["Response_Data"]				= $oData;
				$oResponse["Response_Error_Message"]	= "";
				$oResponse["Response_Error_Reason"]		= "";
			}
		}

		return ResponseBuilder::Response($oResponse);
	}

	public function Selector(Request $Request,$Id){
		if( is_numeric($Id) ){
			return SELF::Index( $Request,$Id );
		}else{
			return SELF::List( $Request,$Id );
		}
	}

	public function Verification(Request $Request){
        $Password  = array();
		$oResponse  = array();
		$oValParams = array( 'User_Email' => 'string|max:250' );


		// VALIDANDO DATOS
		$oResponse = ParamsValidator::Validate_Request($Request,$oValParams,$this->oDomain);

		//  INGRESANDO DATOS
		if ($oResponse["Response_Code"] == 200) {
			$oParam = array(    $Request->input("User_Email")
							);

			$oData = DB::select('call sp_user_validate(?)',$oParam);
			$oData_Id="";
			//  RESPONSE
			if($oData[0]->Response_Success == 1){

                //No existe usuarios con ese email

			}else{
				$oParam = array( $oData[0]->Response_Id );
				$oData_Id= DB::select('call sp_user_index(?)',$oParam);
			}

			$oResponse["Response_Status"]			= $oData[0]->Response_Status;
			$oResponse["Response_Code"]				= $oData[0]->Response_Code;
			$oResponse["Response_Domain"]			= $this->oDomain;
			$oResponse["Response_Message"]			= $oData[0]->Response_Message;
			$oResponse["Response_Data"]				= $oData_Id;
			$oResponse["Response_Error_Message"]	= $oData[0]->Response_Message;
			$oResponse["Response_Error_Reason"]		= $oData[0]->Response_Reason;
		}

		return ResponseBuilder::Response($oResponse);

	}
}

