<?php

namespace App\Http\Controllers\Passenger\ReviewSession;

use App\Http\Helpers\ResponseBuilder;
use App\Modules\Passenger\Application\PassengerSearchWithReview;
use App\Modules\Passenger\Domain\PassengerReviewRange;
use App\Modules\Passenger\Infraestructure\MysqlPassengerSearchWithReviewRepository;
use App\Modules\Shared\Domain\Bus\Command\CommandBus;
use App\Modules\Shared\Domain\DateEnd;
use App\Modules\Shared\Domain\DateStart;
use App\Modules\Shared\Domain\QueryList\ListInput;
use App\Modules\Shared\Infraestructure\Requester;
use Illuminate\Support\Facades\DB;

class ReviewSessionDetailController
{
    public function __construct(
        private CommandBus $commandBus
    ) {
    }

    public function __invoke($idGroupProvider)
    {
        $groupProvider = $this->getGroupProvider($idGroupProvider)['Response_Data'];
        $provider = $this->getProvider($groupProvider[0]->Id_Provider);
        $response = $this->getGroupProviderPassengers($groupProvider[0]->Id_Group);
        $response['Response_Data'] = [
            'Provider' => $provider[0],
            'Group' => $groupProvider[0],
            'Passenger' => $response['Response_Data']
        ];
        return ResponseBuilder::Response($response);
    }

    private function getGroupProvider($idGroupProvider)
    {
        return Requester::requestSelect(
            'CALL sp_passenger_group_provider_index_by_review(?, @sts, @cod, @msg)',
            [ $idGroupProvider ]
        );
    }

    private function getProvider($idProvider)
    {
        return DB::select('CALL sp_provider_index(?)', [ $idProvider ]);
    }

    private function getGroupProviderPassengers($idGroup)
    {
        return (new PassengerSearchWithReview(new MysqlPassengerSearchWithReviewRepository))
            ->__invoke(
                new DateStart(date('Y-m-d')),
                new DateEnd(date('Y-m-d')),
                PassengerReviewRange::NODATE,
                $idGroup,
                'all',
                new ListInput(1, 1000, ''),
                1
            );
    }
}
