<?php

namespace App\Http\Controllers\Passenger\ReviewSession;

use App\Http\Helpers\ResponseBuilder;
use App\Modules\ReviewSession\Domain\ReviewSessionToken;
use App\Modules\ReviewSession\Application\ReviewSessionFinder;
use App\Modules\ReviewSession\Infraestructure\MysqlReviewSessionRepository;
use App\Modules\ReviewSession\Infraestructure\ReviewSessionValidators;
use App\Modules\Shared\Domain\Bus\Command\CommandBus;
use App\Modules\Shared\Validator\Infraestructure\LaravelValidator;
use Illuminate\Http\Request;

class ReviewSessionIndexController
{
    private string $domain;
    public function __construct(
        private CommandBus $commandBus
    ) {
        $this->domain = 'ReviewSession';
    }

    public function __invoke(Request $request)
    {
        (new LaravelValidator)->validate($request->all(), $this->domain, ReviewSessionValidators::INDEX);
        
        $response = (new ReviewSessionFinder(new MysqlReviewSessionRepository()))
            ->__invoke(new ReviewSessionToken($request->input('ReviewSession_Token')));

        return ResponseBuilder::Response($response);
    }
}
