<?php

namespace App\Modules\Booking\Application\Search;

use App\Modules\Booking\Application\Search\BookingSearcherResponse;
use App\Modules\Booking\Domain\BookingCode;
use App\Modules\Booking\Domain\BookingRepository;

final class BookingSearcher
{
    public function __construct(private BookingRepository $repository)
    {
    }

    public function __invoke(BookingCode $bookingCode): BookingSearcherResponse
    {
        return new BookingSearcherResponse($this->repository->search($bookingCode));
    }
}
