<?php

namespace App\Modules\Booking\Application\Search;

use App\Modules\Booking\Domain\BookingCode;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class BookingSearcherQueryHandler implements QueryHandler
{
    public function __construct(private BookingSearcher $inserter)
    {
    }

    public function __invoke(BookingSearcherQuery $query): BookingSearcherResponse
    {
        return $this->inserter->__invoke(
            new BookingCode($query->bookingCode())
        );
    }
}
