<?php

namespace App\Modules\Booking\Domain;

/** Encapsula los inputs necesarios para la búsqueda de los datos que se exportarán a excel */
class ReportExcelRequirements {

    private string $Query;
    private string $DateStart;
    private string $DateEnd;
    private BookingStatus $Booking_Status;
    private UserType $User_Type;
    private BookingType $Booking_Type;

    /** Constructor */
    public function __construct(
        string $Query,
        string $DateStart,
        string $DateEnd,
        BookingStatus $Booking_Status,
        UserType $User_Type,
        BookingType $Booking_Type
    ) {
        $this->Query = $Query;
        $this->DateStart = $DateStart;
        $this->DateEnd = $DateEnd;
        $this->Booking_Status = $Booking_Status;
        $this->User_Type = $User_Type;
        $this->Booking_Type = $Booking_Type;
    }

    public function getQuery():string { return $this->Query; }
    public function getDateStart():string { return $this->DateStart; }
    public function getDateEnd():string { return $this->DateEnd; }
    public function getBooking_Status():BookingStatus { return $this->Booking_Status; }
    public function getUser_Type():UserType { return $this->User_Type; }
    public function getBooking_Type():BookingType { return $this->Booking_Type; }
}