<?php

namespace App\Modules\Booking\Infraestructure;

class BookingInsertValidators {

    public const insert = [
        'Id_User'               => 'int',
        'User_Name'             => 'required|string|max:100',
        'User_LastName'         => 'required|string|max:100',
        'User_Email'            => 'required|string|max:250',
        'User_Phone'            => 'string|max:20',
        'Id_UserCountry'        => 'required|int',
        'Booking'               => 'required|string',
        'CashMovement'          => 'required|string'
    ];

    public const passenger = [
        'Passenger_Name'        => 'string|max:250',
        'Passenger_LastName'    => 'string|max:250',
        'Passenger_Email'       => 'string|max:250',
        'Passenger_Phone'       => 'string|max:100',
        'Passenger_Gender'      => 'string|max:250',
        'Passenger_DOB'         => 'string|max:250',
        'Passenger_NoDocument'  => 'string|max:250',
        'Passenger_Restriction' => 'string',
        'Passenger_Extras'      => 'string',
        'Id_TypeDocument'       => 'required|int',
        'Id_UserCountry'        => 'required|int'
    ];

    public const passengerRequired = [
        'Passenger_Name'        => 'required|string|max:250',
        'Passenger_LastName'    => 'required|string|max:250',
        'Passenger_Email'       => 'string|max:250',
        'Passenger_Phone'       => 'string|max:100',
        'Passenger_Gender'      => 'string|max:250',
        'Passenger_DOB'         => 'string|max:250',
        'Passenger_NoDocument'  => 'required|string|max:250',
        'Passenger_Restriction' => 'string',
        'Passenger_Extras'      => 'string',
        'Id_TypeDocument'       => 'required|int',
        'Id_UserCountry'        => 'required|int'
    ];

    public const passengerEmail = [
        'Passenger_Name'        => 'string|max:250',
        'Passenger_LastName'    => 'string|max:250',
        'Passenger_Email'       => 'required|string|max:250',
        'Passenger_Phone'       => 'string|max:100',
        'Passenger_Gender'      => 'string|max:250',
        'Passenger_DOB'         => 'string|max:250',
        'Passenger_NoDocument'  => 'string|max:250',
        'Passenger_Restriction' => 'string',
        'Passenger_Extras'      => 'string',
        'Id_TypeDocument'       => 'int',
        'Id_UserCountry'        => 'int'
    ];

    public const passengerRequiredEmail = [
        'Passenger_Name'        => 'required|string|max:250',
        'Passenger_LastName'    => 'required|string|max:250',
        'Passenger_Email'       => 'required|string|max:250',
        'Passenger_Phone'       => 'string|max:100',
        'Passenger_Gender'      => 'string|max:250',
        'Passenger_DOB'         => 'string|max:250',
        'Passenger_NoDocument'  => 'required|string|max:250',
        'Passenger_Restriction' => 'string',
        'Passenger_Extras'      => 'string',
        'Id_TypeDocument'       => 'required|int',
        'Id_UserCountry'        => 'required|int'
    ];

}

    