<?php

namespace App\Modules\Booking\Infraestructure;

use App\Modules\Booking\Domain\Booking;
use App\Modules\Booking\Domain\BookingCode;
use App\Modules\Booking\Domain\BookingRepository;
use App\Modules\Booking\Domain\IdBooking;
use App\Modules\Booking\Domain\ReportExcelRequirements;
use App\Modules\Shared\Infraestructure\Requester;
use Illuminate\Support\Facades\DB;

class MysqlBookingRepository implements BookingRepository
{

    public function search(BookingCode $code)
    {
        return Requester::requestSelect(
            'CALL sp_booking_search_by_code(?,@sts,@cod,@msg)',
            [
                $code->value(),
            ]
        );
    }
    public function getReportExcel(ReportExcelRequirements $requirements)
    {
        return DB::select(
            'call sp_booking_report_excel(?,?,?,?,?,?)',
            [
                $requirements->getQuery(),
                $requirements->getDateStart(),
                $requirements->getDateEnd(),
                $requirements->getBooking_Type()->getValue(),
                $requirements->getBooking_Status()->getValue(),
                $requirements->getUser_Type()->getValue(),
            ]
        );
    }
}
