<?php

namespace App\Modules\Booking\Infraestructure;

use App\Modules\Booking\Domain\IdBooking;
use App\Modules\Booking\Domain\PaymentBookingRepository;
use App\Modules\Shared\Infraestructure\Requester;

class MysqlPaymentBookingRepository implements PaymentBookingRepository {

    public function list(string $dateStart, string $dateEnd, string $AdminSession_Token, string $AdminSession_IP, string $path) {
        return Requester::requestSelect(
            'CALL sp_payment_booking_list(?,?,?,?,?,@sts,@cod,@msg)',
            [
                $dateStart,
                $dateEnd,
                $AdminSession_Token,
                $AdminSession_IP,
                $path
            ]
        );
    }

    public function listEquipmentPassenger(string $dateStart, string $dateEnd) {
        return Requester::requestSelect(
            'CALL sp_payment_booking_equipment_by_passenger_list(?,?,@sts,@cod,@msg)',
            [
                $dateStart,
                $dateEnd
            ]
        );
    }

    public function index(IdBooking $id, string $AdminSession_Token, string $AdminSession_IP, string $path) {
        return Requester::requestSelect(
            'CALL sp_payment_booking_index(?,?,?,?,@sts,@cod,@msg)',
            [
                $id->value(),
                $AdminSession_Token,
                $AdminSession_IP,
                $path
            ]
        );
    }

    public function indexEquipmentPassenger(string $dateStart, string $dateEnd) {
        return Requester::requestSelect(
            'CALL sp_payment_booking_tour_passenger_list(?,?,@sts,@cod,@msg)',
            [
                $dateStart,
                $dateEnd
            ]
        );
    }

}
