<?php

namespace App\Modules\BookingRelationship\Infraestructure;

use App\Modules\BookingRelationship\Domain\BookingRelationship;
use App\Modules\BookingRelationship\Domain\BookingRelationshipRepository;
use App\Modules\BookingRelationship\Domain\IdBookingRelationship;
use App\Modules\Shared\Application\ActionHandler;
use Illuminate\Support\Facades\DB;

class MysqlBookingRelationshipRepository implements BookingRelationshipRepository {

    public function insert(BookingRelationship $bookingRelationship) {
        return (new ActionHandler())->handle(DB::select(
            'call sp_booking_relationship_insert(?,?,?,?)',
            [
                $bookingRelationship->getName()->getValue(),
                $bookingRelationship->getAbrv()->getValue(),
                $bookingRelationship->getLock()->getValue(),
                $bookingRelationship->getStatus()->getValue(),
            ]
        ));
    }

    public function update(BookingRelationship $bookingRelationship) {
        return (new ActionHandler())->handle(DB::select(
            'call sp_booking_relationship_update(?,?,?,?)',
            [
                $bookingRelationship->getId()->getValue(),
                $bookingRelationship->getName()->getValue(),
                $bookingRelationship->getAbrv()->getValue(),
                $bookingRelationship->getStatus()->getValue(),
            ]
        ));
    }

    public function index(IdBookingRelationship $id) {
        return DB::select(
            'call sp_booking_relationship_index(?)',
            [
                $id->getValue()
            ]
        );
    }

    public function list($action) {
        return DB::select(
            'call sp_booking_relationship_list(?)',
            [
                $action
            ]
        );
    }
    
}