<?php
namespace App\Modules\BookingTourPassenger\Application;

use App\Providers\ExcelReport\Utils;
use Illuminate\Support\Facades\DB;

class BookingTourPassengerNotificationCreator
{
    public function __construct()
    {
    }

    public function __invoke($idBookingTourPassenger, $token)
    {
        return $this->createNotification($idBookingTourPassenger, $token);
    }

    public function createNotification($idBookingTourPassenger, $token)
    {
        return Utils::compose(
            $this->mapPassenger(
                Utils::compose(
                    $this->saveNotifications($token),
                    [$this, 'passengerToBasicNotification']
                )
            ),
            [$this, 'getPassenger']
        )($idBookingTourPassenger);
    }

    public function createNotificationWithMessage($token, $message)
    {
        return Utils::compose(
            $this->mapPassenger(
                Utils::compose(
                    $this->saveNotifications($token),
                    $this->passengerToMessageNotification($message)
                )
            ),
            [$this, 'getPassenger']
        );
    }

    public function getPassenger($idBookingTourPassenger)
    {
        return DB::select(
            'call sp_booking_tour_passenger_index(?,?)',
            [ $idBookingTourPassenger, config('var.PATH_PUBLIC') . config('var.USER_COUNTRY_THUMB') ]
        );
    }

    public function mapPassenger(callable $funct)
    {
        return function (array $bookingTourPassengers) use ($funct) {
            return array_map($funct, $bookingTourPassengers);
        };
    }

    public function passengerToBasicNotification($passenger)
    {
        if ($passenger->Id_Group == null) {
            return [];
        }
        $groups = explode('||', $passenger->Id_Group);
        $message = 'El pasajero: ' . $passenger->Passenger_Name . ' ' . $passenger->Passenger_LastName . ' ';

        $messages = [
            1 => 'ha sido eliminado del tour. Por favor verificar sus equipamentos',
            0 => 'no ha viajado',
            2 => 'ha sido habilitado',
        ];
        $message .= $messages[$passenger->BookingTourPassenger_Status] ?? '';
        return array_map(fn($idGroup) => (object)[
            'Notification_Description' => $message,
            'Id' => $idGroup
        ], $groups);
    }

    public function passengerToMessageNotification($messageText)
    {
        return function ($passenger) use ($messageText) {
            if ($passenger->Id_Group == null) {
                return [];
            }
            $groups = explode('||', $passenger->Id_Group);
            $message = 'El pasajero: ' . $passenger->Passenger_Name . ' ' . $passenger->Passenger_LastName . ' ';
            $message .= $messageText;
            return array_map(fn($idGroup) => (object)[
                'Notification_Description' => $message,
                'Id' => $idGroup
            ], $groups);
        };
    }

    public function saveNotifications($token)
    {
        return function ($notifications) use ($token) {
            foreach ($notifications as $notification) {
                $oParam = [
                    $notification->Notification_Description,
                    3,
                    $notification->Id,
                    $token,
                    1
                ];
                DB::select('call sp_notification_insert(?,?,?,?,?)', $oParam);
            }
            return $notifications;
        };
    }
}
