<?php

namespace App\Modules\CashMovement\Infraestructure\Validators;

class CashMovementRedistribute {

    public const basic = [
        'CashMovement_DatePayment'      => 'required|string',
        'CashMovement_Amount'           => 'required|numeric',
        'CashMovement_Currency'         => 'required|string|max:4',
        'CashMovement_Name'             => 'required|string|max:100',
        'CashMovement_LastName'         => 'string|max:100',
        'CashMovement_Email'            => 'string|max:250',
        'CashMovement_Country'          => 'string|max:100',
        'CashMovement_City'             => 'string|max:100',
        'CashMovement_Address'          => 'string|max:250',
        'CashMovement_Phone'            => 'string|max:50',
        'CashMovement_CardLast'         => 'required|string|max:10',
        'CashMovement_CardBrand'        => 'required|string|max:50',
        'CashMovement_CardType'         => 'required|string|max:50',
        'CashMovement_CardIssuer'       => 'required|string|max:50',
        'CashMovement_Remark'           => 'string',
        'Id_TypePayment'                => 'required|int',
        'Invoices_In'                   => 'required|string',
        'Invoices_Out'                  => 'required|string'
    ];

    public const invoices = [
        'Invoices_In'                   => 'required|array|min:1',
        'Invoices_In.*.Id_Invoice'      => 'required|int',
        'Invoices_In.*.Amount'          => 'required|numeric',
        'Invoices_Out'                  => 'required|array|min:1',
        'Invoices_Out.*.Id_Invoice'     => 'required|int',
        'Invoices_Out.*.Amount'         => 'required|numeric',
    ];

}