<?php

namespace App\Modules\Group\Application;

use App\Modules\Group\Domain\GroupDateEnd;
use App\Modules\Group\Domain\GroupDateStart;
use App\Modules\Group\Domain\GroupReviewListRepository;
use App\Modules\Provider\Domain\IdProvider;

class GroupReviewList
{
    private GroupReviewListRepository $repository;

    public function __construct(GroupReviewListRepository $repository)
    {
        $this->repository = $repository;
    }

    public function __invoke(
        GroupDateStart $dateStart,
        GroupDateEnd $dateEnd
    ) {
        return $this->repository->__invoke($dateStart, $dateEnd);
    }
}
