<?php

namespace App\Modules\Group\Application\Report;

use App\Modules\Shared\Domain\Bus\Query\Query;
use App\Modules\Shared\Domain\QueryList\ListInput;
use App\Modules\Shared\Domain\ValueObject\DateValueObject;

final class ReportGroupQuery implements Query {

    private string $dateStart;
    private string $dateEnd;
    private ListInput $input;
    
    public function __construct(string $dateStart, string $dateEnd, ListInput $input) {
        $this->dateStart = $dateStart;
        $this->dateEnd = $dateEnd;
        $this->input = $input;
    }

    public function dateStart():string { return $this->dateStart; }
    public function dateEnd():string { return $this->dateEnd; }
    public function input():ListInput { return $this->input; }

}