<?php

namespace App\Modules\Group\Domain;

use App\Modules\Shared\Domain\QueryList\ListInput;

final class ReportGroupFinder
{

    private ReportGroupRepository $repository;

    public function __construct(
        ReportGroupRepository $repository
    ) {
        $this->repository = $repository;
    }

    public function __invoke(GroupDateStart $dateStart, GroupDateEnd $dateEnd, ListInput $list):array
    {
        $model = $this->repository->find($dateStart, $dateEnd, $list);
        return $model;
    }
}
