<?php

namespace App\Modules\HtlCamp\Infraestructure;

use App\Modules\HtlCamp\Domain\HCHtlUsageDateUsage;
use App\Modules\HtlCamp\Domain\HtlCamp;
use App\Modules\HtlCamp\Domain\HtlCampRepository;
use App\Modules\HtlCamp\Domain\IdHtlCamp;
use App\Modules\Shared\Infraestructure\Requester;

class MysqlHtlCampRepository implements HtlCampRepository {

    public function findRoom(IdHtlCamp $idCamp, HCHtlUsageDateUsage $dateUsage) {
        return Requester::requestGeneric(
            'CALL sp_internal_htl_camp_has_room(?,?,@IdHtlRoom, @sts,@cod,@msg)',
            [
                $idCamp->getValue(),
                $dateUsage->getValue(),
            ],
            [
                'Id_HtlRoom' => '@IdHtlRoom'
            ]
        );
    }

    public function find(string $query, string $action) {
        return Requester::requestSelect(
            'CALL sp_htl_camp_list(?,?,@sts,@cod,@msg)',
            [
                $query,
                $action
            ]
        );
    }

    public function index(IdHtlCamp $id) {
        return Requester::requestSelect(
            'CALL sp_htl_camp_index(?,@sts,@cod,@msg)',
            [
                $id->getValue(),
            ]
        );
    }

    public function insert(HtlCamp $value) {
        return Requester::requestInsert(
            'CALL sp_htl_camp_insert(?,?,?,@sts,@cod,@msg,@id)',
            [
                $value->getName()->getValue(),
                $value->getAbrv()->getValue(),
                $value->getStatus()->getValue(),
            ]
        );
    }

    public function update(HtlCamp $value) {
        return Requester::requestUpdate(
            'CALL sp_htl_camp_update(?,?,?,?,@sts,@cod,@msg)',
            [
                $value->getId()->getValue(),
                $value->getName()->getValue(),
                $value->getAbrv()->getValue(),
                $value->getStatus()->getValue(),
            ]
        );
    }

    public function delete(IdHtlCamp $id) {
        return Requester::requestUpdate(
            'CALL sp_htl_camp_delete(?,@sts,@cod,@msg)',
            [
                $id->getValue(),
            ]
        );
    }

}
