<?php

namespace App\Modules\HtlUsage\Infraestructure;

use App\Modules\HtlCamp\Domain\IdHtlCamp;
use App\Modules\HtlUsage\Domain\HtlUsage;
use App\Modules\HtlUsage\Domain\HtlUsageRepository;
use App\Modules\HtlUsage\Domain\HUIdHtlRoom;
use App\Modules\HtlUsage\Domain\IdHtlUsage;
use App\Modules\Shared\Application\ActionHandler;
use App\Modules\Shared\Exceptions\InvalidRequestException;
use App\Modules\Shared\Infraestructure\Requester;
use Illuminate\Support\Facades\DB;

class MysqlHtlUsageRepository implements HtlUsageRepository {

    public function find(HUIdHtlRoom $idHtlRoom, string $query, string $action) {
        return Requester::requestSelect(
            'CALL sp_htl_usage_list(?,?,?,@sts,@cod,@msg)',
            [
                $idHtlRoom->getValue(),
                $query,
                $action
            ]
        );
    }

    public function campFind($dateStart, $dateEnd, IdHtlCamp $idHtlCamp, string $action) {
        return Requester::requestSelect(
            'CALL sp_htl_usage_camp_list(?,?,?,?,@sts,@cod,@msg)',
            [
                $dateStart,
                $dateEnd,
                $idHtlCamp->getValue(),
                $action
            ]
        );
    }

    public function index(IdHtlUsage $id) {
        return Requester::requestSelect(
            'CALL sp_htl_usage_index(?,@sts,@cod,@msg)',
            [
                $id->getValue(),
            ]
        );
    }

    public function insert(HtlUsage $value) {
        return Requester::requestInsert(
            'CALL sp_htl_usage_insert(?,?,?,?,?,?,@sts,@cod,@msg,@id)',
            [
                $value->getDateUsage()->getValue(),
                $value->getStatus()->getValue(),
                $value->getName()->getValue(),
                $value->getLastName()->getValue(),
                $value->getRemark()->getValue(),
                $value->getIdHtlRoom()->getValue(),
            ]
        );
    }

    public function update(HtlUsage $value) {
        return Requester::requestUpdate(
            'CALL sp_htl_usage_update(?,?,?,?,?,?,@sts,@cod,@msg)',
            [
                $value->getId()->getValue(),
                $value->getDateUsage()->getValue(),
                $value->getStatus()->getValue(),
                $value->getName()->getValue(),
                $value->getLastName()->getValue(),
                $value->getRemark()->getValue(),
            ]
        );
    }

    public function delete(IdHtlUsage $id) {
        return Requester::requestUpdate(
            'CALL sp_htl_usage_delete(?,@sts,@cod,@msg)',
            [
                $id->getValue(),
            ]
        );
    }

}
