<?php

namespace App\Modules\Lead\Application\Index;

use App\Modules\Lead\Application\Index\LeadIndexerResponse;
use App\Modules\Lead\Domain\IdLead;
use App\Modules\Lead\Domain\Lead;
use App\Modules\Lead\Domain\LeadRepository;

final class LeadIndexer
{
    public function __construct(private LeadRepository $repository)
    {
    }

    public function __invoke(IdLead $idLead): LeadIndexerResponse
    {
        return new LeadIndexerResponse($this->repository->index($idLead));
    }
}
