<?php

namespace App\Modules\Lead\Domain;

use App\Modules\TypeDocument\Domain\IdTypeDocument;
use App\Modules\UserCountry\Domain\IdUserCountry;

class LightLead
{

    /** constructor */
    public function __construct(
        private LeadName $name,
        private LeadLastName $lastName,
        private LeadGender $gender,
        private LeadEmail $email,
        private LeadPhoneCode $phoneCode,
        private LeadPhone $phone,
        private LeadNoDocument $noDocument,
        private LeadAddress $address,
        private LeadContactName $contactName,
        private LeadContactPhone $contactPhone,
        private LeadType $type,
        private LeadStatus $status,
        private IdTypeDocument $idTypeDocument,
        private IdUserCountry $idUserCountry,
        private ?IdLead $id = null
    ) {
    }
    public function name(): LeadName
    {
        return $this->name;
    }
    public function lastName(): LeadLastName
    {
        return $this->lastName;
    }
    public function gender(): LeadGender
    {
        return $this->gender;
    }
    public function email(): LeadEmail
    {
        return $this->email;
    }
    public function phoneCode(): LeadPhoneCode
    {
        return $this->phoneCode;
    }
    public function phone(): LeadPhone
    {
        return $this->phone;
    }
    public function noDocument(): LeadNoDocument
    {
        return $this->noDocument;
    }
    public function address(): LeadAddress
    {
        return $this->address;
    }
    public function contactName(): LeadContactName
    {
        return $this->contactName;
    }
    public function contactPhone(): LeadContactPhone
    {
        return $this->contactPhone;
    }
    public function type(): LeadType
    {
        return $this->type;
    }
    public function status(): LeadStatus
    {
        return $this->status;
    }
    public function idTypeDocument(): IdTypeDocument
    {
        return $this->idTypeDocument;
    }
    public function idUserCountry(): IdUserCountry
    {
        return $this->idUserCountry;
    }
    public function id(): IdLead
    {
        return $this->id;
    }
}
