<?php

namespace App\Modules\LeadBookingPackage\Application\Create;

use App\Modules\LeadBooking\Domain\IdLeadBooking;
use App\Modules\LeadBookingPackage\Application\Create\LeadBookingPackageInserterResponse;
use App\Modules\LeadBookingPackage\Domain\InsertLeadBookingPackage;
use App\Modules\LeadBookingPackage\Domain\LeadBookingPackage;
use App\Modules\LeadBookingPackage\Domain\LeadBookingPackageRepository;
use App\Modules\LeadBookingTour\Application\GroupList\LeadBookingTourGroupLister;
use App\Modules\LeadBookingTour\Application\List\LeadBookingTourLister;
use App\Modules\LeadBookingTour\Domain\IdLeadBookingTour;
use App\Modules\LeadBookingTour\Domain\LeadBookingTourGroup;

final class LeadBookingPackageInserter
{
    public function __construct(
        private LeadBookingPackageRepository $repository,
    ) {
    }

    public function __invoke(InsertLeadBookingPackage $leadBookingPackage, int $passengers)
    {
        $response = $this->repository->insert($leadBookingPackage);
        $groupNumber = $response['Response_Data']['Id'];
        $this->repository->addPassengers(
            new LeadBookingPackage(
                $leadBookingPackage->idLeadBooking(),
                new LeadBookingTourGroup($groupNumber)
            ),
            $passengers
        );
        return $response;
    }
}
