<?php

namespace App\Modules\LeadBookingService\Application\Index;

use App\Modules\LeadBookingService\Application\Index\LeadBookingServiceIndexerResponse;
use App\Modules\LeadBookingService\Domain\IdLeadBookingService;
use App\Modules\LeadBookingService\Domain\LeadBookingService;
use App\Modules\LeadBookingService\Domain\LeadBookingServiceRepository;

final class LeadBookingServiceIndexer
{
    public function __construct(private LeadBookingServiceRepository $repository)
    {
    }

    public function __invoke(IdLeadBookingService $idLeadBookingService): LeadBookingServiceIndexerResponse
    {
        return new LeadBookingServiceIndexerResponse($this->repository->index($idLeadBookingService));
    }
}
